/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xsltmp.util;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.fileselectors.IncludeExcludeFileSelector;

public class UnArchiverHelper {
    private final Log log;
    private final MavenProject project;
    private final ArchiverManager archiverManager;
    private final File commonExtractDir;
    private final Map archiveValidSubdirs;

    public UnArchiverHelper(Log log, MavenProject project, ArchiverManager archiverManager, String commonExtractDir) {
        this.log = log;
        this.project = project;
        this.archiverManager = archiverManager;
        this.commonExtractDir = new File(this.getProject().getBuild().getDirectory(), commonExtractDir);
        this.archiveValidSubdirs = new HashMap();
    }

    public Log getLog() {
        return this.log;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public ArchiverManager getArchiverManager() {
        return this.archiverManager;
    }

    public File getCommonExtractDir() {
        return this.commonExtractDir;
    }

    public Map getArchiveValidSubdirs() {
        return this.archiveValidSubdirs;
    }

    public File getFile(File archive, String filePath) {
        File extractDir;
        File result;
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Getting: " + filePath + " from archive: " + archive));
        }
        if (!(result = new File(extractDir = this.getExtractDir(archive), filePath)).exists()) {
            this.extract(archive, filePath);
            if (!result.exists()) {
                Iterator iterator = this.getArchiveSubdirs(archive).iterator();
                while (iterator.hasNext()) {
                    String subdir = (String)iterator.next();
                    String newFilePath = new File(subdir, filePath).getPath();
                    this.extract(archive, newFilePath);
                    result = new File(extractDir, newFilePath);
                }
            } else {
                this.storeValidSubdir(archive, filePath);
            }
        }
        return result;
    }

    private void storeValidSubdir(File archive, String filePath) {
        String subdir = new File(filePath).getParent();
        this.getArchiveSubdirs(archive).add(subdir);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Storing last valid subdir for archive: " + archive.getName() + " as: " + subdir));
        }
    }

    private HashSet getArchiveSubdirs(File archive) {
        HashSet set = (HashSet)this.getArchiveValidSubdirs().get(archive.getName());
        if (null == set) {
            set = new HashSet();
            this.getArchiveValidSubdirs().put(archive.getName(), set);
        }
        return set;
    }

    public void extract(File archive, String filePath) {
        File extractDir = this.getExtractDir(archive);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Extracting: " + filePath + " from: " + archive + " to: " + extractDir));
        }
        extractDir.mkdirs();
        try {
            UnArchiver unArchiver = this.getArchiverManager().getUnArchiver(archive);
            unArchiver.setSourceFile(archive);
            unArchiver.setDestDirectory(extractDir);
            IncludeExcludeFileSelector[] selectors = new IncludeExcludeFileSelector[]{new IncludeExcludeFileSelector()};
            selectors[0].setIncludes(new String[]{filePath});
            unArchiver.setFileSelectors((FileSelector[])selectors);
            unArchiver.extract();
        }
        catch (NoSuchArchiverException e) {
            this.getLog().warn((CharSequence)"Unknown archiver type.");
        }
        catch (ArchiverException e) {
            this.getLog().warn((CharSequence)("Error unpacking file: " + archive + "\t" + e.toString()));
        }
    }

    private File getExtractDir(File archive) {
        return new File(this.commonExtractDir, archive.getName());
    }
}

