/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xsltmp;

import java.io.File;
import java.io.IOException;
import net.sf.xsltmp.XsltGeneratorConstants;
import net.sf.xsltmp.util.TimestampUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class FinalizeMojo
extends AbstractMojo
implements XsltGeneratorConstants {
    private MavenProject project;

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        TimestampUtils timestampUtils = new TimestampUtils(this.project);
        File prepared = timestampUtils.getPreparedTimestampFile();
        File file = timestampUtils.getTimestampFile();
        timestampUtils.getTimestampDir().mkdirs();
        try {
            file.createNewFile();
            if (prepared.exists()) {
                file.setLastModified(prepared.lastModified());
                this.getLog().info((CharSequence)"Finalized.");
            } else {
                file.setLastModified(System.currentTimeMillis());
                this.getLog().warn((CharSequence)"Finalized by setting timestamp as system time, prepared timestamp not available. (Did you forget to configure an initialize goal?)");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }
}

