/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xsltmp.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;
import org.apache.tools.ant.util.LineTokenizer;

public class StreamTranslator {
    private final String startToken;
    private final String endToken;
    private final Map resourceMap;
    private final Log log;
    private String line;
    private int startIndex;
    private int endIndex;

    public StreamTranslator(String startToken, String endToken, Map resourceMap, Log log) {
        this.startToken = startToken;
        this.endToken = endToken;
        this.resourceMap = resourceMap;
        this.log = log;
    }

    public Reader translate(Reader reader) throws IOException {
        StringBuilder sb = new StringBuilder();
        LineTokenizer lineTokenizer = new LineTokenizer();
        lineTokenizer.setIncludeDelims(true);
        this.line = lineTokenizer.getToken(reader);
        while (this.line != null) {
            String lineBefore = this.line;
            this.translateLine();
            if (this.log.isDebugEnabled() && !lineBefore.equals(this.line)) {
                this.log.debug((CharSequence)("Line before: " + lineBefore.trim()));
                this.log.debug((CharSequence)("Line after : " + this.line.trim()));
            }
            sb.append(this.line);
            this.line = lineTokenizer.getToken(reader);
        }
        return new StringReader(sb.toString());
    }

    private void translateLine() {
        this.startIndex = 0;
        this.nextStartToken();
        while (this.isStartIndexValid()) {
            this.nextEndIndex();
            if (this.endIndex < 0) {
                this.skip();
            } else {
                String token = this.getToken();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((CharSequence)("Translating token: " + token));
                }
                if (!this.isTokenValid(token)) {
                    this.skip();
                } else {
                    this.replaceToken(this.getReplaceFor(token));
                }
            }
            this.nextStartToken();
        }
    }

    private void nextStartToken() {
        this.startIndex = this.line.indexOf(this.startToken, this.startIndex);
    }

    private boolean isStartIndexValid() {
        return this.startIndex >= 0 && this.startIndex + this.startToken.length() <= this.line.length();
    }

    private void nextEndIndex() {
        this.endIndex = this.line.indexOf(this.endToken, this.startIndex + this.startToken.length());
    }

    private void skip() {
        ++this.startIndex;
    }

    private String getToken() {
        return this.line.substring(this.startIndex + this.startToken.length(), this.endIndex);
    }

    private boolean isTokenValid(String token) {
        for (int k = 0; k < token.length(); ++k) {
            char c = token.charAt(k);
            if (c != ':' && c != '=' && !Character.isSpaceChar(c)) continue;
            return false;
        }
        return true;
    }

    private String getReplaceFor(String token) {
        if (this.resourceMap.containsKey(token)) {
            return (String)this.resourceMap.get(token);
        }
        this.log.warn((CharSequence)("Translation missing for token: " + token));
        return this.startToken + token + this.endToken;
    }

    private void replaceToken(String replace) {
        this.line = this.line.substring(0, this.startIndex) + replace + this.line.substring(this.endIndex + this.endToken.length());
        this.startIndex += replace.length();
    }
}

