/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xsltmp.filter;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.sf.xsltmp.filter.Filter;
import net.sf.xsltmp.util.BundleLoader;
import net.sf.xsltmp.util.FileResolver;
import net.sf.xsltmp.util.StreamTranslator;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;

public class TranslatingFilter
implements Filter {
    private String startToken;
    private String endToken;
    private String bundle;
    private String bundleLanguage;
    private String bundleCountry;
    private String bundleVariant;
    private String bundleEncoding;
    private FileResolver fileResolver;
    private MavenProject project;
    private Log log;
    private final Map resourceMap = new HashMap();
    private Map filterParameters;

    public void setMavenProject(MavenProject project) {
        this.project = project;
    }

    public void setFileResolver(FileResolver fileResolver) {
        this.fileResolver = fileResolver;
        this.log = fileResolver.getLog();
    }

    public void setFilterParameters(Map filterParameters) {
        this.filterParameters = filterParameters;
        this.startToken = this.getParam("startToken", "#");
        this.endToken = this.getParam("endToken", "#");
        this.bundle = this.getParam("bundle", "Resource");
        this.bundleLanguage = this.getParam("bundleLanguage", Locale.getDefault().getLanguage());
        this.bundleCountry = this.getParam("bundleCountry", Locale.getDefault().getCountry());
        this.bundleVariant = this.getParam("bundleVariant", Locale.getDefault().getVariant());
        this.bundleEncoding = this.getParam("bundleEncoding", this.project.getProperties().get("project.build.sourceEncoding"));
        if (StringUtils.isEmpty((String)this.bundleEncoding)) {
            this.bundleEncoding = System.getProperty("file.encoding");
            this.log.warn((CharSequence)("Source encoding has not been set, using platform encoding " + this.bundleEncoding + ", i.e. build is platform dependent!"));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)("Initialized TranslatingFilter: startToken=" + this.startToken + ", endToken=" + this.endToken + ", bundle=" + this.bundle + ", bundleLanguage=" + this.bundleLanguage + ", bundleCountry=" + this.bundleCountry + ", bundleVariant=" + this.bundleVariant + ", bundleEncoding=" + this.bundleEncoding));
        }
    }

    private String getParam(String key, Object defaultValue) {
        if (null != this.filterParameters && this.filterParameters.containsKey(key)) {
            return (String)this.filterParameters.get(key);
        }
        return (String)defaultValue;
    }

    public void init() {
        new BundleLoader(this.bundle, this.bundleLanguage, this.bundleCountry, this.bundleVariant, this.bundleEncoding, this.fileResolver, this.resourceMap).loadBundle();
    }

    public Reader filter(Reader reader, String name) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)("Filtering file: " + name));
        }
        return new StreamTranslator(this.startToken, this.endToken, this.resourceMap, this.log).translate(reader);
    }
}

