/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xsltmp;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import net.sf.xsltmp.XsltGeneratorConstants;
import net.sf.xsltmp.util.DefaultURIResolver;
import net.sf.xsltmp.util.UnArchiverHelper;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.util.StringUtils;

public abstract class XsltGeneratorBase
extends AbstractMojo
implements XsltGeneratorConstants {
    protected ArchiverManager archiverManager;
    private MavenProject project;
    private String xslTemplate;
    private Map parameters;
    private boolean force;
    private String sourceEncoding;
    private String filter;
    private Map filterParameters;
    private Transformer transformer = null;
    private File xslFile = null;
    protected DefaultURIResolver resolver = null;
    private UnArchiverHelper helper = null;
    private File timestamp = null;

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public ArchiverManager getArchiverManager() {
        return this.archiverManager;
    }

    public void setArchiverManager(ArchiverManager archiverManager) {
        this.archiverManager = archiverManager;
    }

    public String getXslTemplate() {
        return this.xslTemplate;
    }

    public void setXslTemplate(String xslTemplate) {
        this.xslTemplate = xslTemplate;
    }

    public Map getParameters() {
        if (null == this.parameters) {
            this.parameters = new HashMap();
        }
        return this.parameters;
    }

    public void setParameters(Map parameters) {
        this.parameters = parameters;
    }

    public boolean getForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public String getSourceEncoding() {
        if (StringUtils.isEmpty((String)this.sourceEncoding)) {
            this.sourceEncoding = System.getProperty("file.encoding");
            this.getLog().warn((CharSequence)("Source encoding has not been set, using platform encoding " + this.sourceEncoding + ", i.e. build is platform dependent!"));
        }
        return this.sourceEncoding;
    }

    public void setSourceEncoding(String sourceEncoding) {
        this.sourceEncoding = sourceEncoding;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public Map getFilterParameters() {
        return this.filterParameters;
    }

    public void setFilterParameters(Map filterParameters) {
        this.filterParameters = filterParameters;
    }

    public Transformer getTransformer() throws MojoFailureException {
        if (null == this.transformer) {
            this.createTransformer();
        }
        return this.transformer;
    }

    public DefaultURIResolver getResolver() {
        if (null == this.resolver) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Setting up DefaultURIResolver: sourceEncoding=" + this.getSourceEncoding() + ", filter=" + this.getFilter() + ", filterParameters=" + this.getFilterParameters()));
            }
            this.resolver = new DefaultURIResolver(this.getLog(), this.getProject(), this.getHelper(), this.getSourceEncoding(), this.getFilter(), this.getFilterParameters());
        }
        return this.resolver;
    }

    public UnArchiverHelper getHelper() {
        if (null == this.helper) {
            this.helper = new UnArchiverHelper(this.getLog(), this.getProject(), this.getArchiverManager(), "xslt-generator-maven-plugin/extracts");
        }
        return this.helper;
    }

    public File getXslFile() {
        if (null == this.xslFile) {
            this.xslFile = this.getResolver().resolve(this.getXslTemplate());
        }
        return this.xslFile;
    }

    public File getTimestamp() {
        if (null == this.timestamp) {
            File timestampDir = new File(this.getProject().getBuild().getDirectory(), "xslt-generator-maven-plugin");
            this.timestamp = new File(timestampDir, "timestamp");
        }
        return this.timestamp;
    }

    private void createTransformer() throws MojoFailureException {
        this.getLog().debug((CharSequence)"Creating transformer.");
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setURIResolver(this.getResolver());
        try {
            this.transformer = factory.newTransformer(this.getResolver().resolveAsSource(this.getXslTemplate()));
        }
        catch (TransformerConfigurationException tce) {
            tce.printStackTrace();
            throw new MojoFailureException("Cannot process template file: " + this.getXslTemplate(), (Throwable)tce);
        }
        this.applyParameters();
    }

    private void applyParameters() throws MojoFailureException {
        this.getLog().debug((CharSequence)"Applying parameters.");
        if (this.getParameters() != null) {
            Set keys = this.getParameters().keySet();
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Setting parameter: key=" + key + " value=" + this.getParameters().get(key)));
                }
                this.getTransformer().setParameter(key, this.getParameters().get(key));
            }
            if (this.getParameters().isEmpty()) {
                this.getLog().debug((CharSequence)"No parameters to set.");
            }
        }
    }

    protected boolean verifyXsltFileExist() {
        if (!this.getXslFile().exists()) {
            this.getLog().warn((CharSequence)("Generation not performed, XSL file was not found: " + this.getXslTemplate()));
            return false;
        }
        return true;
    }

    protected String getLogPrefix() {
        return this.getMojoName() + ": " + this.getXslTemplate();
    }

    protected boolean hasChanged(File file) {
        if (this.getForce()) {
            return true;
        }
        return file.lastModified() > this.getTimestamp().lastModified();
    }

    protected abstract String getMojoName();
}

