/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xsltmp;

import java.io.File;
import java.util.ArrayList;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.xsltmp.FromManyBase;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public abstract class ManyToManyBase
extends FromManyBase {
    private File destDir;
    private String addDestDirTo;

    public File getDestDir() {
        return this.destDir;
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public String getAddDestDirTo() {
        return this.addDestDirTo;
    }

    public void setAddDestDirTo(String addDestDirTo) {
        this.addDestDirTo = addDestDirTo;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean didRun = false;
        try {
            if (!this.verifyXsltFileExist()) {
                return;
            }
            if (!this.verifySrcDirExist()) {
                return;
            }
            this.ensureDestDirExists();
            boolean xslFileChanged = this.hasChanged(this.getXslFile());
            String[] sourceFileNames = this.getSourceFiles();
            for (int i = 0; i < sourceFileNames.length; ++i) {
                File srcFile = this.getSourceFile(sourceFileNames[i]);
                File destFile = this.getDestFile(sourceFileNames[i]);
                if (!(xslFileChanged || !this.shouldSkip(srcFile, destFile) && this.hasChanged(srcFile))) {
                    if (!this.getLog().isDebugEnabled()) continue;
                    this.getLog().debug((CharSequence)("File skipped: " + srcFile));
                    continue;
                }
                didRun = true;
                this.ensureDestFileDirExists(destFile);
                this.logExecution(srcFile);
                this.getTransformer().transform(new StreamSource(srcFile), new StreamResult(destFile));
                this.cleanAfterFileTransformation(destFile);
            }
            if (!didRun) {
                this.getLog().info((CharSequence)"No sources to process.");
            }
            this.addDestDir();
        }
        catch (MojoFailureException mfe) {
            throw mfe;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    protected abstract File getDestFile(String var1);

    protected abstract boolean shouldSkip(File var1, File var2);

    protected void cleanAfterFileTransformation(File destFile) {
    }

    protected void ensureDestDirExists() throws MojoFailureException {
        boolean dirCreationResult;
        if (!this.getDestDir().exists() && !(dirCreationResult = this.getDestDir().mkdirs())) {
            throw new MojoFailureException("Destination directory structure could not be initialised. Failed to create directory: " + this.getDestDir());
        }
    }

    protected void addDestDir() {
        if ("sources".equals(this.getAddDestDirTo())) {
            this.getProject().addCompileSourceRoot(this.getDestDir().getAbsolutePath());
            this.logAddedDestDir();
        }
        if ("test-sources".equals(this.getAddDestDirTo())) {
            this.getProject().addTestCompileSourceRoot(this.getDestDir().getAbsolutePath());
            this.logAddedDestDir();
        }
        if ("resources".equals(this.getAddDestDirTo())) {
            this.getProject().addResource(this.getDestDirResource());
            this.logAddedDestDir();
        }
        if ("test-resources".equals(this.getAddDestDirTo())) {
            this.getProject().addTestResource(this.getDestDirResource());
            this.logAddedDestDir();
        }
    }

    private Resource getDestDirResource() {
        Resource resource = new Resource();
        resource.setDirectory(this.getDestDir().getAbsolutePath());
        ArrayList<String> excludes = new ArrayList<String>();
        excludes.add("**/*.java");
        resource.setExcludes(excludes);
        return resource;
    }

    private void logAddedDestDir() {
        this.getLog().info((CharSequence)("Added to " + this.getAddDestDirTo() + " destDir: " + this.getDestDir().getAbsolutePath()));
    }
}

