/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xsltmp.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import net.sf.xsltmp.filter.Filter;
import net.sf.xsltmp.util.FileResolver;
import net.sf.xsltmp.util.UnArchiverHelper;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class DefaultURIResolver
extends FileResolver
implements URIResolver {
    private final String filterType;
    private final Map filterParameters;
    private Filter filter;

    public DefaultURIResolver(Log log, MavenProject project, UnArchiverHelper helper, String filter, Map filterParameters) {
        super(log, project, helper);
        this.filterType = filter;
        this.filterParameters = filterParameters;
    }

    public Source resolve(String href, String base) throws TransformerConfigurationException {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Resolving: " + href + " at base: " + base));
        }
        File result = null;
        try {
            File baseFile = new File(new URI(base));
            result = new File(baseFile.getParentFile(), href);
        }
        catch (URISyntaxException e) {
            this.getLog().warn((CharSequence)("Unable to parse URI: " + base));
        }
        if (!this.exists(result)) {
            result = this.resolve(href);
        }
        if (result.exists()) {
            return this.createSource(result);
        }
        return null;
    }

    protected Source createSource(File file) throws TransformerConfigurationException {
        try {
            Reader reader = new FileReader(file);
            reader = this.wrapInFilter(reader, file.toString());
            StreamSource source = new StreamSource(reader);
            source.setSystemId(file);
            return source;
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            throw new TransformerConfigurationException("File not found: " + file, fnfe);
        }
    }

    private Reader wrapInFilter(Reader reader, String name) throws TransformerConfigurationException {
        if (null != this.filterType) {
            try {
                if (null == this.filter) {
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)("Initializing filter: " + this.filterType));
                    }
                    this.filter = (Filter)Class.forName(this.filterType).newInstance();
                    this.filter.setMavenProject(this.getProject());
                    this.filter.setFileResolver(this);
                    this.filter.setFilterParameters(this.filterParameters);
                    this.filter.init();
                }
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Applying filter: " + this.filterType));
                }
                return this.filter.filter(reader, name);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new TransformerConfigurationException("Cannot process filter: " + this.filterType, e);
            }
        }
        return reader;
    }

    public Source resolveAsSource(String filePath) throws TransformerConfigurationException {
        File file = this.resolve(filePath);
        return this.createSource(file);
    }
}

