/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xsltmp.util;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import net.sf.xsltmp.util.UnArchiverHelper;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class FileResolver {
    private final Log log;
    private final MavenProject project;
    private final UnArchiverHelper helper;

    public FileResolver(Log log, MavenProject project, UnArchiverHelper helper) {
        this.log = log;
        this.project = project;
        this.helper = helper;
    }

    public Log getLog() {
        return this.log;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public UnArchiverHelper getHelper() {
        return this.helper;
    }

    public File resolve(String filePath) {
        this.getLog().debug((CharSequence)("Resolving: " + filePath + " at absolute, " + "basedir or classpath"));
        File result = new File(filePath);
        if (this.exists(result)) {
            return result;
        }
        result = new File(this.getProject().getBasedir(), filePath);
        if (this.exists(result)) {
            return result;
        }
        try {
            List classpaths = this.getProject().getCompileClasspathElements();
            Iterator iterator = classpaths.iterator();
            while (iterator.hasNext()) {
                File classpath = new File((String)iterator.next());
                result = classpath.isFile() ? this.getHelper().getFile(classpath, filePath) : new File(classpath, filePath);
                if (!this.exists(result)) continue;
                return result;
            }
        }
        catch (DependencyResolutionRequiredException e) {
            this.getLog().warn((CharSequence)("Dependencies must be resolved first, could not locate " + filePath + " from classpath"));
        }
        this.getLog().debug((CharSequence)"- Not resolved");
        return result;
    }

    protected boolean exists(File file) {
        if (null == file) {
            return false;
        }
        this.getLog().debug((CharSequence)("- Trying: " + file.getAbsolutePath()));
        boolean result = file.exists();
        if (result) {
            this.getLog().debug((CharSequence)"- Resolved");
        }
        return result;
    }
}

