/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xsltmp.util;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import net.sf.xsltmp.util.FileResolver;
import net.sf.xsltmp.util.UnArchiverHelper;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class DefaultURIResolver
extends FileResolver
implements URIResolver {
    public DefaultURIResolver(Log log, MavenProject project, UnArchiverHelper helper) {
        super(log, project, helper);
    }

    public Source resolve(String href, String base) {
        this.getLog().debug((CharSequence)("Resolving: " + href + " at base: " + base));
        File result = null;
        try {
            File baseFile = new File(new URI(base));
            result = new File(baseFile.getParentFile(), href);
        }
        catch (URISyntaxException e) {
            this.getLog().warn((CharSequence)("Unable to parse URI: " + base));
        }
        if (!this.exists(result)) {
            result = this.resolve(href);
        }
        if (result.exists()) {
            return new StreamSource(result);
        }
        return null;
    }
}

