/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xmlform.web;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import net.sf.xmlform.web.ClassResource;
import net.sf.xmlform.web.RequestMessageParameters;

public class ResourceUtil {
    public static void outputResource(HttpServletResponse resp, String param) throws Exception {
        StringBuffer sb = new StringBuffer();
        String[] parts = param.split(":");
        String[] params = parts[1].split(",");
        Class<?> c = Class.forName(parts[0]);
        for (int j = 0; j < params.length; ++j) {
            if (params[j].length() <= 0) continue;
            InputStream is = c.getResourceAsStream(params[j]);
            if (is == null) {
                System.out.println("Not found resource: " + params[j] + " in " + param);
                continue;
            }
            ResourceUtil.writeStream(is, resp);
            is.close();
        }
        ResourceUtil.outputInline(resp, sb.toString());
    }

    public static void outputFile(HttpServletResponse resp, String file) throws Exception {
        FileInputStream fis = new FileInputStream(file);
        ResourceUtil.writeStream(fis, resp);
        fis.close();
    }

    public static void outputClass(ServletContext servletContext, HttpServletRequest req, HttpServletResponse resp, String className) throws Exception {
        String clazz = className;
        String param = "";
        if (clazz.indexOf(":") > 0) {
            param = clazz.substring(clazz.indexOf(":") + 1);
            clazz = clazz.substring(0, clazz.indexOf(":"));
        }
        ClassResource cla = (ClassResource)Class.forName(clazz).newInstance();
        cla.outputResource(servletContext, req, resp, param);
        resp.getOutputStream().flush();
    }

    public static void outputInline(HttpServletResponse resp, String script) throws Exception {
        ResourceUtil.outputString(resp, script);
    }

    public static void outputString(HttpServletResponse resp, String script) throws Exception {
        ByteArrayInputStream sb = new ByteArrayInputStream(script.getBytes("UTF-8"));
        ResourceUtil.writeStream(sb, resp);
        sb.close();
    }

    private static void writeStream(InputStream is, HttpServletResponse resp) throws IOException {
        if (is == null) {
            return;
        }
        ServletOutputStream out = resp.getOutputStream();
        byte[] buf = new byte[1024];
        int len = is.read(buf);
        while (len > 0) {
            out.write(buf, 0, len);
            len = is.read(buf);
        }
        out.flush();
    }

    static void writeStream(Reader reader, OutputStream output) throws IOException {
        if (output == null) {
            return;
        }
        OutputStreamWriter out = new OutputStreamWriter(output, "UTF-8");
        char[] buf = new char[1024];
        int len = reader.read(buf);
        while (len > 0) {
            out.write(buf, 0, len);
            len = reader.read(buf);
        }
        out.flush();
    }

    public static RequestMessageParameters getCommonParameters(ServletContext servletContext, HttpServletRequest req) {
        return new RequestMessageParameters(servletContext, req);
    }
}

