/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xmlform.web;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import net.sf.xmlform.util.MapMessageParameters;

public class RequestMessageParameters
extends MapMessageParameters {
    public static final String KEY_LOCALE = "locale";
    public static final String KEY_CONTEXTPATH = "contextPath";
    public static final String KEY_THEME = "theme";
    private ServletContext servletContext;
    private HttpServletRequest servletRequest;

    public RequestMessageParameters(ServletContext servletContext, HttpServletRequest servletRequest) {
        this.servletContext = servletContext;
        this.servletRequest = servletRequest;
    }

    public String getParameter(String key) {
        Object v = this.servletRequest.getParameter(key);
        if (v != null) {
            return this.objectToString(v);
        }
        v = this.servletRequest.getAttribute(key);
        if (v != null) {
            return this.objectToString(v);
        }
        HttpSession ses = this.servletRequest.getSession();
        if (ses != null && (v = ses.getAttribute(key)) != null) {
            return this.objectToString(v);
        }
        v = this.servletContext.getAttribute(key);
        if (v != null) {
            return this.objectToString(v);
        }
        if (KEY_LOCALE.equals(key)) {
            return this.servletRequest.getLocale().toString();
        }
        if (KEY_CONTEXTPATH.equals(key)) {
            String ctxPath = this.servletRequest.getContextPath();
            if ("/".equals(ctxPath)) {
                ctxPath = "";
            }
            return ctxPath;
        }
        return super.getParameter(key);
    }
}

