/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xmlform.web;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import net.sf.xmlform.util.MapMessageParameters;
import net.sf.xmlform.util.MessageParameters;
import net.sf.xmlform.util.MessageUtil;
import net.sf.xmlform.web.BatchResourceLocations;
import net.sf.xmlform.web.ResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchResourceServlet
extends HttpServlet {
    private static Logger _log = LoggerFactory.getLogger(BatchResourceServlet.class);
    public static final String KEY_MESSAGE_PARAMETERS = MapMessageParameters.class.getName();
    public static final String KEY_RESOURCE_LOCATIONS = BatchResourceLocations.class.getName();
    public static final String JS_FILE = "file";
    public static final String JS_CLASS = "class";
    public static final String JS_INCLUDE = "include";
    public static final String JS_INLINE = "inline";
    public static final String JS_RESOURCE = "resource";
    public static final String JS_HEADER = "header";
    private static String JS_FILE_PREFIX = "file=";
    private static String JS_CLASSPATH_PREFIX = "classpath=";
    private static String JS_INCLUDEFILE_PREFIX = "includefile=";
    private static String JS_INCLUDECLASSPATH_PREFIX = "includeclasspath=";
    private static String JS_CLASS_PREFIX = "class=";
    private static String JS_INLINE_PREFIX = "inline=";
    private static String JS_HEADER_PREFIX = "header=";
    private static String JS_RESOURCE_PREFIX = "resource=";
    private static String SEP = "=";
    private static BatchResourceLocations batchResourceLocations = new BatchResourceLocations(){
        {
            this.setFileLocations(new String[]{"/"});
            this.setClassLocations(new String[]{"/"});
        }
    };

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        BatchResourceServlet.process(req, resp);
    }

    public static void process(HttpServletRequest req, HttpServletResponse resp) {
        BatchResourceLocations locations;
        Object params = (MessageParameters)req.getServletContext().getAttribute(KEY_MESSAGE_PARAMETERS);
        if (params == null) {
            params = (MessageParameters)req.getAttribute(KEY_MESSAGE_PARAMETERS);
        }
        if (params == null) {
            params = ResourceUtil.getCommonParameters(req.getServletContext(), req);
        }
        if ((locations = (BatchResourceLocations)req.getServletContext().getAttribute(KEY_RESOURCE_LOCATIONS)) == null) {
            locations = (BatchResourceLocations)req.getAttribute(KEY_MESSAGE_PARAMETERS);
        }
        if (locations == null) {
            locations = batchResourceLocations;
        }
        BatchResourceServlet.process(req, resp, params, locations);
    }

    public static void process(HttpServletRequest req, HttpServletResponse resp, MessageParameters params, BatchResourceLocations locations) {
        String path = req.getRequestURI();
        if (!"/".equals(req.getContextPath()) && req.getContextPath().length() > 0) {
            path = path.substring(req.getContextPath().length());
        }
        ReaderInfo readerInfo = null;
        try {
            readerInfo = BatchResourceServlet.getReaderFromFile(locations.getFileLocations(), path);
            if (readerInfo == null) {
                readerInfo = BatchResourceServlet.getReaderFromClasspath(locations.getClassLocations(), path);
            }
            if (readerInfo == null) {
                return;
            }
        }
        catch (Exception e) {
            _log.error("Read javascript config file: " + path, (Throwable)e);
        }
        BatchResourceServlet.readJs(params, locations, req, resp, readerInfo, true);
    }

    private static void readJs(MessageParameters map, BatchResourceLocations locations, HttpServletRequest req, HttpServletResponse resp, ReaderInfo readerInfo, boolean isFirst) {
        try {
            BufferedReader br = readerInfo.br;
            String js = br.readLine();
            while (js != null) {
                if (isFirst && js.startsWith(JS_HEADER_PREFIX)) {
                    String head = BatchResourceServlet.getParamString(js);
                    resp.addHeader(head.substring(0, head.indexOf(SEP)), BatchResourceServlet.getParamString(head));
                } else {
                    BatchResourceServlet.parseLine(map, locations, req, resp, readerInfo, MessageUtil.formatMessage((String)js, (MessageParameters)map));
                }
                js = br.readLine();
            }
            br.close();
        }
        catch (Exception e) {
            _log.error("Read batch resource config file: " + readerInfo.relativeDir, (Throwable)e);
        }
    }

    private static ReaderInfo getReaderFromFile(String[] fileLocations, String fileName) throws Exception {
        if (fileLocations != null) {
            String baseDir = BatchResourceServlet.getBaseDir();
            for (int f = 0; f < fileLocations.length; ++f) {
                File file = new File(BatchResourceServlet.convertPath(baseDir + fileLocations[f] + fileName));
                if (!file.exists()) continue;
                ReaderInfo info = new ReaderInfo();
                info.absoluteDir = file.getParent() + "/";
                info.br = new BufferedReader(new FileReader(file));
                return info;
            }
        }
        return null;
    }

    private static ReaderInfo getReaderFromClasspath(String[] classLocations, String fileName) throws Exception {
        if (!fileName.startsWith("/")) {
            throw new IllegalArgumentException("Classpath file name must begin '/'");
        }
        if (classLocations != null) {
            for (int f = 0; f < classLocations.length; ++f) {
                InputStream file = BatchResourceServlet.class.getResourceAsStream(BatchResourceServlet.convertPath(classLocations[f] + fileName));
                if (file == null) continue;
                ReaderInfo info = new ReaderInfo();
                info.relativeDir = BatchResourceServlet.getRelativeDir(fileName);
                info.br = new BufferedReader(new InputStreamReader(file, "UTF-8"));
                return info;
            }
        }
        return null;
    }

    private static void parseLine(MessageParameters map, BatchResourceLocations locations, HttpServletRequest req, HttpServletResponse resp, ReaderInfo readerInfo, String line) throws Exception {
        block12: {
            String key;
            block15: {
                block14: {
                    block13: {
                        block11: {
                            if (line.startsWith("#")) {
                                return;
                            }
                            int sepIdx = line.indexOf(SEP);
                            if (sepIdx < 1) {
                                return;
                            }
                            key = line.substring(0, sepIdx + 1).toLowerCase();
                            if (!JS_CLASSPATH_PREFIX.equals(key)) break block11;
                            String classPathFile = BatchResourceServlet.getParamString(line);
                            ReaderInfo info = BatchResourceServlet.getReaderFromClasspath(locations.getClassLocations(), classPathFile);
                            if (info == null) {
                                _log.info("Classpath file not found: " + classPathFile);
                                return;
                            }
                            ResourceUtil.writeStream(info.br, (OutputStream)resp.getOutputStream());
                            break block12;
                        }
                        if (!JS_RESOURCE_PREFIX.equals(key)) break block13;
                        ResourceUtil.outputResource(resp, BatchResourceServlet.getParamString(line));
                        break block12;
                    }
                    if (!JS_INLINE_PREFIX.equals(key)) break block14;
                    ResourceUtil.outputInline(resp, BatchResourceServlet.getParamString(line));
                    break block12;
                }
                if (!JS_FILE_PREFIX.equals(key)) break block15;
                String fileName = BatchResourceServlet.findFile(locations.getFileLocations(), readerInfo, BatchResourceServlet.getParamString(line));
                if (fileName == null) break block12;
                ResourceUtil.outputFile(resp, fileName);
                break block12;
            }
            if (JS_CLASS_PREFIX.equals(key)) {
                ResourceUtil.outputClass(req.getServletContext(), req, resp, BatchResourceServlet.getParamString(line));
            } else if (JS_INCLUDEFILE_PREFIX.equals(key)) {
                String[] jsFiles = BatchResourceServlet.getParamString(line).split(",");
                for (int i = 0; i < jsFiles.length; ++i) {
                    String fileName = BatchResourceServlet.findFile(locations.getFileLocations(), readerInfo, BatchResourceServlet.getParamString(jsFiles[i]));
                    if (fileName == null) continue;
                    File file = new File(fileName);
                    ReaderInfo info = new ReaderInfo();
                    info.absoluteDir = file.getParent() + "/";
                    info.br = new BufferedReader(new FileReader(file));
                    BatchResourceServlet.readJs(map, locations, req, resp, info, false);
                }
            } else if (JS_INCLUDECLASSPATH_PREFIX.equals(key)) {
                String[] jsFiles = BatchResourceServlet.getParamString(line).split(",");
                for (int i = 0; i < jsFiles.length; ++i) {
                    String p = BatchResourceServlet.convertPath(jsFiles[i]);
                    ReaderInfo info = BatchResourceServlet.getReaderFromClasspath(locations.getClassLocations(), p);
                    if (info == null) {
                        _log.info("Classpath file not found: " + p);
                        continue;
                    }
                    BatchResourceServlet.readJs(map, locations, req, resp, info, false);
                }
            }
        }
    }

    private static String findFile(String[] fileLocations, ReaderInfo readerInfo, String name) {
        Object newName = null;
        if (name.startsWith("/")) {
            newName = name;
        } else if (readerInfo.absoluteDir != null) {
            newName = readerInfo.absoluteDir + name;
        } else {
            String baseDir = BatchResourceServlet.getBaseDir();
            for (int f = 0; f < fileLocations.length; ++f) {
                File file = new File(BatchResourceServlet.convertPath(baseDir + fileLocations[f] + readerInfo.relativeDir + name));
                if (!file.exists()) continue;
                return file.getAbsolutePath();
            }
        }
        if (new File((String)newName).exists()) {
            return newName;
        }
        _log.info("Filesystem file not found: " + name);
        return null;
    }

    static String getRelativeDir(String className) {
        int idx = className.lastIndexOf("/");
        if (idx < 0) {
            return "";
        }
        return className.substring(0, idx + 1);
    }

    private static String getParamString(String line) {
        return line.substring(line.indexOf(SEP) + 1);
    }

    private static String convertPath(String path) {
        return path.replaceAll("\\\\", "/").replaceAll("//", "/");
    }

    private static String getBaseDir() {
        return new File("").getAbsolutePath();
    }

    static class ReaderInfo {
        String absoluteDir;
        String relativeDir;
        BufferedReader br;

        ReaderInfo() {
        }
    }
}

