/*

Author: Liu Zhikun
http://javaxmlform.sourceforge.net/
*/
(function(global,factory){
	if (typeof module !== 'undefined' && typeof exports === 'object' && define.cmd) {
		module.exports = factory();
	} else if (typeof define === 'function' && define.amd) {
		define("xmlform/panel",factory);
	} else {
		global.xmlformPanel = factory();
	}
})(typeof window!=="undefined" ? window:this,function(){
	
var panelObj={};
panelObj.locale="en";
panelObj.loadReference=function(){
	alert("Please provide panel.loadReference=function([{id:,action:,form:,field:,fieldArgs:,valueArgs]){...}");
};
panelObj.getFileUploadUrl=null;
panelObj.getFileDownloadUrl=function(id){return id;};
panelObj.XmlformPanel=function(config){
	/*
	config["xmlformForm"]=xmlform;
	config["xmlformLayout"]=layout;
	setXmlformRecordset:function(recordSet)
	getXmlformRecordset:function()
	*/
};
panelObj.getFormCssCls=function(formName){
	return "xfform-"+formName.toLowerCase().replace(/\./g,"-");
};
panelObj.getFormCaptionCls=function(formName){
	return "xfform-formcaption";
};
panelObj.getFieldCssCls=function(fieldName){
	return "xffield-"+fieldName.toLowerCase();
};
panelObj.getFieldRequiredCls=function(fieldType){
	return "xfrequiredfield";
};
panelObj.getFieldReadonlyCls=function(fieldType){
	return "xfreadonlyfield";
};
panelObj.getFieldInvalidCls=function(fieldType){
	return "xfinvalidfield";
};
panelObj.getRowSeverityCls=function(severity){
	return "xfrowseverity"+severity;
};
panelObj.getFieldSeverityCls=function(severity){
	return "xffieldseverity"+severity;
};
panelObj.getLayoutCssCls=function(cls){
	return cls;
};
panelObj.getTypeHAlign=function(type){
	var align="";
	if(type=="date"||type=="datetime"||type=="yearmonth"||type=="time"||type=="boolean"){
		align="center";
	}else if(type=="byte"||type=="decimal"||type=="double"||type=="float"
		||type=="integer"||type=="int"||type=="long"||type=="short"){
		align="right";
	}else{
		align="left";
	}
	return align;
};

panelObj.getDefaultWidgetParams=function(){
	return {autofirst:"0",autosingle:"1",emptyclean:"1"};
};
panelObj.getInputBestWidth=function(){
	return 150;
};
panelObj.getInputMinWidth=function(){
	return 50;
};
panelObj.getInputBestHeight=function(){
	return 150;
};
panelObj.getGridColWidth=function(){
	return 150;
};
panelObj.getFormHeightByWidth=function(w){
	return w*3/4;
};
panelObj.isFixedTableColumnWidth=function(){
	return false;
};
panelObj.isAutoResizeTableColumnWidth=function(){
	return true;
};
panelObj.isTableCellOverflowEllipsis=function(){
	return false;
};
panelObj.isShowDropDownButtonByFocus=function(){
	return false;
};
panelObj.isSelectTextOnFocus=function(){
	return true;
};
panelObj.isSelectTextOnClick=function(){
	return true;
};
panelObj.isCssStyle=function(name){
	return false;
};
panelObj.findLocale=function(locale,map){
	var m=findLocale(locale,map);
	if(m==null){
		return findLocale("en",map);
	}
	return m;
};
panelObj.createFormFieldWidget=function(param){
	/*
	 * param={
	 * 	form:
	 * 	field:{
	 * 		
	 * 	},
	 * 	widget:{
	 * 		type:
	 * 		
	 * 	}
	 * }
	 */
};
panelObj.createFormSubformWidget=function(param){
	/*
	 * param={
	 * 	form:
	 * 	field:{
	 * 		
	 * 	},
	 * 	widget:{
	 * 		type:
	 * 		
	 * 	}
	 * }
	 */
};

function findLocale(locale,map){
	var ls=locale.split("_");
	var arr=[];
	var len=ls.length;
	for(var i=0;i<ls.length;i++){
		var str="";
		for(s=0;s<len;s++){
			if(str.length>0){
				str+="_";
			}
			str+=ls[s];
		}
		arr[i]=str;
		len--;
	}
	for(var i=0;i<arr.length;i++){
		if(map[arr[i]]){
			return map[arr[i]];
		}
	}
	return null;
};

return panelObj;
});
/********
	"not-support"
	*** boolean ***
	"boolean-input"
	"boolean-select"
	"boolean-checkbox"
	*** byte ***
	"byte-input"
	"byte-select"
	"byte-radio"
	"byte-search"
	*** datetime ***
	"datetime-input"
	"datetime-select"
	"datetime-search"
	
	*** date ***
	"date-input"
	"date-select"
	"date-search"
	
	*** decimal ***
	"decimal-input"
	"decimal-select"
	"decimal-radio"
	"decimal-search"
	"decimal-tree"

	*** double ***
	"double-input"
	"double-select"
	"double-radio"
	"double-search"
	"double-tree"
	
	***float***
	"float-input"
	"float-select"
	"float-radio"
	"float-search"
	"float-tree"
	
	*** integer ***
	"integer-input"
	"integer-select"
	"integer-radio"
	"integer-search"
	"integer-tree"
	
	"int-input"
	"int-select"
	"int-radio"
	"int-search"
	"int-tree"
	
	*** long ***
	"long-input"
	"long-select"
	"long-radio"
	"long-search"
	"long-tree"
	
	*** short ***
	"short-input"
	"short-select"
	"short-radio"
	"short-search"
	"short-tree"
	
	*** string ***
	"string-input"
	"string-select"
	"string-radio"
	"string-search"
	"string-password"
	"string-tree"
	"string-textarea"
	"string-multiselect"
	"string-multicheckbox"
	
	*** time ***
	"time-input"
	"time-select"
	"time-search"
	
	*** yearmonth ***
	"yearmonth-input"
	"yearmonth-select"
	"yearmonth-search"
	
	*** subform ***
	"subform-panel"
	"subform-dialog"

********/