/*
XMLForm Validator

Author: Liu Zhikun
http://javaxmlform.sourceforge.net/
*/
(function(global,factory){
	if (typeof module !== 'undefined' && typeof exports === 'object' && define.cmd) {
		module.exports = factory();
	} else if (typeof define === 'function' && define.amd) {
		define("xmlform/format",factory);
	} else {
		global.xmlformFormat = factory();
	}
})(typeof window!=="undefined" ? window:this,function(){
	
var formatObject={};
formatObject.formatFieldValue=function(field,value){
	var type=field.getType();
	if(formatObject.XmlformFieldFormats[type])
		return formatObject.XmlformFieldFormats[type](field,value);
	return value;
};
formatObject.XmlformFieldFormats={
	"datetime":function(field,value){
		return this.__xfdtfmt(11,field.getConfig().format,value);
	},
	"date":function(field,value){
		return this.__xfdtfmt(0,field.getConfig().format,value);
	},
	"time":function(field,value){
		return this.__xfdtfmt(0,field.getConfig().format,value);
	},
	"__xfdtOpt":{
		"y+":function(of,value){return value.substr(0,4);}, //Year 	Year 	1996; 96
		"M+":function(of,value){return value.substr(5,2)}, //Month in year 	Month 	July; Jul; 07
//		w 	Week in year 	Number 	27
//		W 	Week in month 	Number 	2
//		D 	Day in year 	Number 	189
		"d+":function(of,value){return value.substr(8,2)}, //Day in month 	Number 	10
//		F 	Day of week in month 	Number 	2
//		E 	Day in week 	Text 	Tuesday; Tue
//		a 	Am/pm marker 	Text 	PM
		"H+":function(of,value){return value.substr(of+0,2)},//Hour in day (0-23) 	Number 	0
//		k 	Hour in day (1-24) 	Number 	24
//		K 	Hour in am/pm (0-11) 	Number 	0
//		h 	Hour in am/pm (1-12) 	Number 	12
		"m+":function(of,value){return value.substr(of+3,2)},//Minute in hour 	Number 	30
		"s+":function(of,value){return value.substr(of+6,2)}//Second in minute 	Number 	55       
	},
	"__xfdtfmt":function(offset,format,value){
//			    var week = {
//			    "0" : "/u65e5",           
//			    "1" : "/u4e00",           
//			    "2" : "/u4e8c",           
//			    "3" : "/u4e09",           
//			    "4" : "/u56db",           
//			    "5" : "/u4e94",           
//			    "6" : "/u516d"          
//			    };
				var newv=format;
			    for(var k in this.__xfdtOpt){
			        if(new RegExp("("+ k +")").test(newv)){
			        	var v=this.__xfdtOpt[k](offset,value);
			        	if(k=="y+"){
			        		v=v.substr(v.length-RegExp.$1.length);
			        	}else if(RegExp.$1.length==1&&v.substr(0,1)=="0"){
			        		v=v.substr(v.length-1);
			        	}
			        	newv=newv.replace(RegExp.$1, v);
			        }      
			    }           
			    return newv;   
	}
};
return formatObject;
});