package net.sf.xmlform.web.context;

import java.util.Locale;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import net.sf.xmlform.XMLFormPastport;

public class ServletXMLFormPastport implements XMLFormPastport{
	final private static String LOCALE_KEY=ServletXMLFormPastport.class.getName();
	private ServletContext _context;
	private HttpServletRequest _req;
	private String[] _profiles=new String[0];
	public ServletXMLFormPastport(ServletContext context,HttpServletRequest req){
		_context=context;
		_req=req;
	}
	public String getSessionId() {
		return _req.getSession(true).getId();
	}
	public String getRemoteAddr(){
		return _req.getRemoteAddr();
	}
	public int getRemotePort(){
		return _req.getRemotePort();
	}
	public Locale getLocale() {
		HttpSession session=_req.getSession(true);
		Locale loc=(Locale)session.getAttribute(LOCALE_KEY);
		if(loc!=null)
			return loc;
		return _req.getLocale();
	}
	public void setLocale(Locale loc){
		HttpSession session=_req.getSession(true);
		session.setAttribute(LOCALE_KEY,loc);
	}
	public Object getLocal(String key){
		HttpSession session=_req.getSession(true);
		return session.getAttribute(key);
	}
	public void setLocal(String key,Object value){
		HttpSession session=_req.getSession(true);
		session.setAttribute(key,value);
	}
	public Object getGlobal(String key){
		return _context.getAttribute(key);
	}
	public void setGlobal(String key,Object value){
		_context.setAttribute(key, value);
	}
//	public String[] getActiveProfiles(){
//		return _profiles;
//	}
//	public void setActiveProfiles(String... profiles){
//		this._profiles=profiles;
//	}
}

