package net.sf.xmlform.web;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import net.sf.xmlform.util.MapMessageParameters;

/**
 * @author Liu Zhikun
 */

public class RequestMessageParameters extends MapMessageParameters {
	final public static String KEY_LOCALE="locale",KEY_CONTEXTPATH="contextPath",KEY_THEME="theme";
	private ServletContext servletContext;
	private HttpServletRequest servletRequest;
	public RequestMessageParameters(ServletContext servletContext, HttpServletRequest servletRequest) {
		super();
		this.servletContext = servletContext;
		this.servletRequest = servletRequest;
	}
	
	public String getParameter(String key) {
		Object v=servletRequest.getParameter(key);
		if(v!=null)
			return objectToString(v);
		v=servletRequest.getAttribute(key);
		if(v!=null)
			return objectToString(v);
		HttpSession ses=servletRequest.getSession();
		if(ses!=null){
			v=ses.getAttribute(key);
			if(v!=null)
				return objectToString(v);
		}
		v=servletContext.getAttribute(key);
		if(v!=null)
			return objectToString(v);
		if(KEY_LOCALE.equals(key)){
			return servletRequest.getLocale().toString();
		}
		if(KEY_CONTEXTPATH.equals(key)){
			String ctxPath=servletRequest.getContextPath();
			if("/".equals(ctxPath))
				ctxPath="";
			return ctxPath;
		}
		return super.getParameter(key);
	}
	
}
