package net.sf.xmlform.web;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.sf.xmlform.util.MapMessageParameters;
import net.sf.xmlform.util.MessageParameters;
import net.sf.xmlform.util.MessageUtil;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 *
 * example:<br>
 *header=Content-Type=text/javascript; charset=UTF-8<br>
 *file=jquery-1.3.2.min.js<br>
 *file=jscolor.js<br>
 *resource=net.sf.xmlform.html.ClassResource:js/xmlform.js,abc.js<br>
 *inline=alert("${locale}"+"abc");<br>
 *class=net.sf.xmlform.html.js.LocaleValidator:${locale}<br>
 *include=../otherjs/test.br<br>
 *
 * @author Liu Zhikun
 */

public class BatchResourceServlet extends HttpServlet {
	private static Logger _log = LoggerFactory.getLogger(BatchResourceServlet.class);
	final public static String KEY_MESSAGE_PARAMETERS=MapMessageParameters.class.getName();
	final public static String JS_FILE="file",JS_CLASS="class",JS_INCLUDE="include",
		JS_INLINE="inline",JS_RESOURCE="resource",JS_HEADER="header";
	private static String JS_FILE_PREFIX="file=",JS_INCLUDE_PREFIX="include=",
		JS_CLASS_PREFIX="class=",JS_INLINE_PREFIX="inline=",JS_HEADER_PREFIX="header=",
		JS_RESOURCE_PREFIX="resource=",SEP="=";
	protected void doGet(HttpServletRequest req, HttpServletResponse resp)throws ServletException, IOException {
		process(req,resp);
	}
	static public void process(HttpServletRequest req, HttpServletResponse resp){
		MessageParameters params=(MessageParameters)req.getServletContext().getAttribute(KEY_MESSAGE_PARAMETERS);
		if(params==null)
			params=(MessageParameters)req.getAttribute(KEY_MESSAGE_PARAMETERS);
		if(params==null)
			params=ResourceUtil.getCommonParameters(req.getServletContext(), req);
		process(req,resp,params);
	}
	static public void process(HttpServletRequest req, HttpServletResponse resp,MessageParameters params){
		String path=req.getRequestURI();
		if((!"/".equals(req.getContextPath()))&&req.getContextPath().length()>0)
			path=path.substring(req.getContextPath().length());
		path=convertPath(req.getServletContext().getRealPath(path));
		path=path.substring(0,path.lastIndexOf("/")+1);
		String file=convertPath(req.getRequestURI());
		file=file.substring(file.lastIndexOf("/")+1);
		readJs(params,req, resp,path,file,true);
	}
	static private void readJs(MessageParameters map,HttpServletRequest req, HttpServletResponse resp,String path,String jsFile,boolean isFirst){
		try {
			BufferedReader br = new BufferedReader(new FileReader(convertPath(path+jsFile)));
			String js=br.readLine();
			while(js!=null){
				if(isFirst==true&&js.startsWith(JS_HEADER_PREFIX)){
					String head=getParamString(js);
					resp.addHeader(head.substring(0, head.indexOf(SEP)), getParamString(head));
				}else{
					parseLine(map,jsFile,req,resp,path,MessageUtil.formatMessage(js,map));
				}
				js=br.readLine();
			}
			br.close();
		} catch (Exception e) {
			_log.error("Read javascript config file: "+path+jsFile,e);
		}
	}
	static private void parseLine(MessageParameters map,String jsFile,HttpServletRequest req, HttpServletResponse resp,String path,String line){
		try{
			if(line.startsWith(JS_RESOURCE_PREFIX)){
				ResourceUtil.outputResource(resp,getParamString(line));
			}else if(line.startsWith(JS_INLINE_PREFIX)){
				ResourceUtil.outputInline(resp,getParamString(line));
			}else if(line.startsWith(JS_FILE_PREFIX)){
				ResourceUtil.outputFile(resp,convertPath(path+getParamString(line)));
			}else if(line.startsWith(JS_CLASS_PREFIX)){
				ResourceUtil.outputClass(req.getServletContext(),req,resp,getParamString(line));
			}else if(line.startsWith(JS_INCLUDE_PREFIX)){
				String jsFiles[]=getParamString(line).split(",");
				for(int i=0;i<jsFiles.length;i++){
					String p=convertPath(jsFiles[i]);
					String f=p;
					if(p.indexOf("/")>=0){
						f=p.substring(p.lastIndexOf("/")+1);
						p=p.substring(0,p.lastIndexOf("/")+1);
					}else{
						p="";
					}
					String fileName=convertPath(path+p)+f;
					File file=new File(fileName);
					if(!file.exists()){
						_log.info("Resource file not found: "+fileName);
						continue;
					}
					readJs(map,req,resp,convertPath(path+p),f,false);
				}
			}
		}catch(Exception e){
			e.printStackTrace();
			_log.error("Read javascript config file: "+path+jsFile+" : "+line,e);
		}
	}
	static private String getParamString(String line){
		return line.substring(line.indexOf(SEP)+1);
	}
	static private String convertPath(String path){
		return path.replaceAll("\\\\","/").replaceAll("//","/");
	}
}
