/*
 * Decompiled with CFR 0.152.
 */
package org.xmldb.api;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.XMLDBException;

public class DatabaseManager {
    protected static final String URI_PREFIX = "xmldb:";
    static Properties properties = new Properties();
    static Hashtable databases = new Hashtable();

    public static Database[] getDatabases() {
        Enumeration e = databases.elements();
        Database[] result = new Database[databases.size()];
        int i = 0;
        while (e.hasMoreElements()) {
            result[i] = (Database)e.nextElement();
            ++i;
        }
        return result;
    }

    public static void registerDatabase(Database database) throws XMLDBException {
        if (database.getName() == null || database.getName().equals("")) {
            throw new XMLDBException(401);
        }
        String[] databaseNames = database.getNames();
        if (databaseNames == null || databaseNames.length == 0 || databaseNames[0].equals("")) {
            throw new XMLDBException(401);
        }
        for (int i = 0; i < databaseNames.length; ++i) {
            databases.put(databaseNames[i], database);
        }
    }

    public static void deregisterDatabase(Database database) throws XMLDBException {
        String[] databaseNames = database.getNames();
        if (databaseNames != null) {
            for (int i = 0; i < databaseNames.length; ++i) {
                databases.remove(databaseNames[i]);
            }
        }
    }

    public static Collection getCollection(String uri) throws XMLDBException {
        return DatabaseManager.getCollection(uri, null, null);
    }

    public static Collection getCollection(String uri, String username, String password) throws XMLDBException {
        Database db = DatabaseManager.getDatabase(uri);
        uri = DatabaseManager.stripURIPrefix(uri);
        return db.getCollection(uri, username, password);
    }

    public static String getConformanceLevel(String uri) throws XMLDBException {
        Database database = DatabaseManager.getDatabase(uri);
        return database.getConformanceLevel();
    }

    public static String getProperty(String name) {
        return properties.getProperty(name);
    }

    public static void setProperty(String name, String value) {
        properties.put(name, value);
    }

    protected static Database getDatabase(String uri) throws XMLDBException {
        if (!uri.startsWith(URI_PREFIX)) {
            throw new XMLDBException(5);
        }
        int end = uri.indexOf(":", URI_PREFIX.length());
        if (end == -1) {
            throw new XMLDBException(5);
        }
        String databaseName = uri.substring(URI_PREFIX.length(), end);
        Database db = (Database)databases.get(databaseName);
        if (db == null) {
            throw new XMLDBException(400);
        }
        return db;
    }

    protected static String stripURIPrefix(String uri) throws XMLDBException {
        if (!uri.startsWith(URI_PREFIX)) {
            throw new XMLDBException(5);
        }
        String dbURI = uri.substring(URI_PREFIX.length(), uri.length());
        return dbURI;
    }
}

