/*
 * Decompiled with CFR 0.152.
 */
package org.ogf.graap.wsag.api.types;

import org.apache.xmlbeans.XmlObject;
import org.ogf.graap.wsag.api.AgreementOffer;
import org.ogf.graap.wsag.api.types.NegotiationOfferTypeImpl;
import org.ogf.graap.wsag.api.types.WSAGXmlType;
import org.ogf.schemas.graap.wsAgreement.AgreementContextType;
import org.ogf.schemas.graap.wsAgreement.AgreementOfferDocument;
import org.ogf.schemas.graap.wsAgreement.AgreementTemplateType;
import org.ogf.schemas.graap.wsAgreement.AgreementType;
import org.ogf.schemas.graap.wsAgreement.CreateAgreementInputDocument;
import org.ogf.schemas.graap.wsAgreement.CreateAgreementInputType;
import org.ogf.schemas.graap.wsAgreement.NoncriticalExtensionType;
import org.ogf.schemas.graap.wsAgreement.TermTreeType;
import org.ogf.schemas.graap.wsAgreement.negotiation.NegotiationOfferType;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class AgreementOfferType
extends WSAGXmlType
implements AgreementOffer {
    private final CreateAgreementInputDocument agreementOfferDocument = CreateAgreementInputDocument.Factory.newInstance();
    private AgreementType offer;

    public AgreementOfferType(AgreementTemplateType template) {
        AgreementType processed = this.processTemplate(template);
        this.initialize(processed);
    }

    public AgreementOfferType(NegotiationOfferTypeImpl negotiationOffer) {
        this(negotiationOffer.getXMLObject());
    }

    public AgreementOfferType(NegotiationOfferType negotiationOffer) {
        AgreementOfferDocument offerDoc = AgreementOfferDocument.Factory.newInstance();
        offerDoc.addNewAgreementOffer();
        if (negotiationOffer.isSetAgreementId()) {
            offerDoc.getAgreementOffer().setAgreementId(negotiationOffer.getAgreementId());
        }
        if (negotiationOffer.isSetName()) {
            offerDoc.getAgreementOffer().setName(negotiationOffer.getName());
        }
        if (negotiationOffer.getContext() != null) {
            offerDoc.getAgreementOffer().addNewContext().set(negotiationOffer.getContext().copy());
        }
        if (negotiationOffer.getTerms() != null) {
            offerDoc.getAgreementOffer().addNewTerms().set(negotiationOffer.getTerms().copy());
        }
        this.initialize(offerDoc.getAgreementOffer());
    }

    public AgreementOfferType(AgreementType offer) {
        this.initialize((AgreementType)offer.copy());
    }

    private void initialize(AgreementType offerTemplate) {
        if (offerTemplate == null) {
            throw new IllegalStateException("Parameter Template must not be null.");
        }
        if (offerTemplate.getContext() == null) {
            throw new IllegalStateException("Parameter Template#Context must not be null.");
        }
        if (offerTemplate.getTerms() == null) {
            throw new IllegalStateException("Parameter Template#Terms must not be null.");
        }
        CreateAgreementInputType input = this.agreementOfferDocument.addNewCreateAgreementInput();
        this.offer = (AgreementType)input.addNewAgreementOffer().set((XmlObject)offerTemplate);
        String agreementId = offerTemplate.getAgreementId() != null ? offerTemplate.getAgreementId() : "1";
        String agreementName = offerTemplate.getName() != null ? offerTemplate.getName() : "AGREEMENT_OFFER";
        this.setAgreementId(agreementId);
        this.setName(agreementName);
    }

    public EndpointReferenceType getInitiatorEPR() {
        return this.getAgreementInput().getInitiatorAgreementEPR();
    }

    public NoncriticalExtensionType[] getNoncriticalExtensions() {
        return this.getAgreementInput().getNoncriticalExtensionArray();
    }

    public void setInitiatorEPR(EndpointReferenceType initiatorAgreementEPR) {
        this.getAgreementInput().setInitiatorAgreementEPR(initiatorAgreementEPR);
    }

    public void setNoncriticalExtensions(NoncriticalExtensionType[] noncriticalExtensionArray) {
        this.getAgreementInput().setNoncriticalExtensionArray(noncriticalExtensionArray);
    }

    public String getAgreementId() {
        return this.getAgreementOffer().getAgreementId();
    }

    public AgreementContextType getContext() {
        return this.getAgreementOffer().getContext();
    }

    public String getName() {
        return this.getAgreementOffer().getName();
    }

    public TermTreeType getTerms() {
        return this.getAgreementOffer().getTerms();
    }

    public void setAgreementId(String agreementId) {
        this.getAgreementOffer().setAgreementId(agreementId);
    }

    public void setContext(AgreementContextType context) {
        this.getAgreementOffer().setContext(context);
    }

    public void setName(String name) {
        this.getAgreementOffer().setName(name);
    }

    public void setTerms(TermTreeType terms) {
        this.getAgreementOffer().setTerms(terms);
    }

    public boolean validate() {
        return this.validate((XmlObject)this.agreementOfferDocument);
    }

    private CreateAgreementInputType getAgreementInput() {
        return this.agreementOfferDocument.getCreateAgreementInput();
    }

    private AgreementType getAgreementOffer() {
        return this.offer;
    }

    public AgreementType getXMLObject() {
        return this.offer;
    }
}

