/*
 * Decompiled with CFR 0.152.
 */
package org.ogf.graap.wsag.api.exceptions;

import java.text.MessageFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlString;
import org.oasisOpen.docs.wsrf.bf2.BaseFaultDocument;
import org.oasisOpen.docs.wsrf.bf2.BaseFaultType;
import org.ogf.graap.wsag.api.exceptions.WSAgreementException;
import org.ogf.schemas.graap.wsAgreement.ContinuingFaultDocument;
import org.ogf.schemas.graap.wsAgreement.ContinuingFaultType;

public class AgreementFactoryException
extends WSAgreementException {
    private static final int ERROR_CODE = 1000;
    public static final String LOCAL_EN = "en";
    private static final String DESCRIPTION_MESSAGE = "{0}: {1}";
    private static final String CAUSE_MESSAGE = "Caused by {0}: {1}";
    private static final String STACKTRACE_MESSAGE = "\tat {0}";
    private Calendar timestamp = new GregorianCalendar();
    private static final long serialVersionUID = 1L;

    public AgreementFactoryException() {
    }

    public AgreementFactoryException(String message) {
        super(message);
    }

    public AgreementFactoryException(String message, ContinuingFaultType fault) {
        super(message);
        XmlObject[] causeDoc;
        BaseFaultType.FaultCause cause = fault.getFaultCause();
        if (cause != null && (causeDoc = cause.selectChildren(ContinuingFaultDocument.type.getDocumentElementName())).length > 0) {
            ContinuingFaultType cf = (ContinuingFaultType)causeDoc[0];
            AgreementFactoryException rootEx = new AgreementFactoryException(cf.getDescriptionArray(0).getStringValue(), cf);
            this.initCause(rootEx);
        }
    }

    public AgreementFactoryException(String message, Throwable cause) {
        super(message, cause);
    }

    public AgreementFactoryException(Throwable cause) {
        super(cause);
    }

    public BaseFaultType getBaseFault() {
        BaseFaultDocument baseFaultDocument = BaseFaultDocument.Factory.newInstance();
        BaseFaultType baseFault = baseFaultDocument.addNewBaseFault();
        baseFault.addNewErrorCode();
        baseFault.getErrorCode().setDialect("http://schemas.scai.fraunhofer.de/wsag4j");
        baseFault.getErrorCode().set((XmlObject)XmlString.Factory.newValue((Object)this.getErrorCode()));
        baseFault.setTimestamp(this.timestamp);
        BaseFaultType.Description description = baseFault.addNewDescription();
        description.setLang(LOCAL_EN);
        description.setStringValue(MessageFormat.format(DESCRIPTION_MESSAGE, this.getClass().getName(), this.getMessage()));
        StackTraceElement[] stackTrace = this.getStackTrace();
        for (int i = 0; i < stackTrace.length; ++i) {
            description = baseFault.addNewDescription();
            description.setLang(LOCAL_EN);
            description.setStringValue(MessageFormat.format(STACKTRACE_MESSAGE, stackTrace[i]));
        }
        if (this.getCause() != null) {
            description = baseFault.addNewDescription();
            description.setLang(LOCAL_EN);
            description.setStringValue(MessageFormat.format(CAUSE_MESSAGE, this.getCause().getClass().getName(), this.getCause().getMessage()));
        }
        return baseFault;
    }

    protected String getErrorCode() {
        return Integer.toString(1000);
    }
}

