/*
 * Decompiled with CFR 0.152.
 */
package org.ogf.graap.wsag.api.configuration;

import org.apache.log4j.Logger;
import org.ogf.graap.wsag.api.configuration.WSAG4JConfigurationEnvironment;
import org.ogf.graap.wsag.api.logging.LogMessage;

public class WSAG4JEnvironment
implements WSAG4JConfigurationEnvironment {
    private static final Logger LOG = Logger.getLogger(WSAG4JEnvironment.class);
    public static final String DEFAULT_CONFIGURATION_PATH_KEY = "wsag4j.configuration.path";
    public static final String DEFAULT_CONFIGURATION_PATH = "/etc/wsag4j";
    public static final String DEFAULT_CONFIGURATION_FILE = "wsag4j.properties";
    private String configurationPath = null;

    public WSAG4JEnvironment() {
        String message = "WSAG4J environment properties file not found. Using default configuration path {0}.";
        LOG.debug((Object)LogMessage.getMessage(message, DEFAULT_CONFIGURATION_PATH));
        this.configurationPath = DEFAULT_CONFIGURATION_PATH;
    }

    public WSAG4JEnvironment(String path) {
        if (path == null) {
            path = DEFAULT_CONFIGURATION_PATH;
            String message = "Configuration path not specified in WSAG4J environment properties file. Using default configuration path {0}.";
            LOG.debug((Object)LogMessage.getMessage(message, DEFAULT_CONFIGURATION_PATH));
        } else {
            String message = "Configuration path specified in WSAG4J environment properties file. Path: {0}";
            LOG.debug((Object)LogMessage.getMessage(message, path));
        }
        this.configurationPath = path;
    }

    public String getConfigurationPath() {
        String defaultPath = System.getProperty(DEFAULT_CONFIGURATION_PATH_KEY);
        if (defaultPath != null) {
            String message = "Found system property {0} with value {1} (overwriting directory from configuration file {2}).";
            LOG.info((Object)LogMessage.getMessage(message, DEFAULT_CONFIGURATION_PATH_KEY, defaultPath, this.configurationPath));
            return defaultPath;
        }
        return this.configurationPath;
    }
}

