/*
 * Decompiled with CFR 0.152.
 */
package org.ogf.graap.wsag.api.configuration;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Properties;
import org.apache.commons.discovery.log.SimpleLog;
import org.apache.commons.discovery.resource.ClassLoaders;
import org.apache.commons.discovery.tools.DefaultClassHolder;
import org.apache.commons.discovery.tools.DiscoverClass;
import org.apache.commons.discovery.tools.DiscoverSingleton;
import org.apache.commons.discovery.tools.PropertiesHolder;
import org.apache.commons.discovery.tools.ResourceUtils;
import org.apache.commons.discovery.tools.SPInterface;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.ogf.graap.wsag.api.configuration.WSAG4JConfigurationEnvironment;
import org.ogf.graap.wsag.api.configuration.WSAG4JEnvironment;
import org.ogf.graap.wsag.api.logging.LogMessage;
import org.ogf.graap.wsag4j.types.configuration.ConfigurationDocument;
import org.ogf.graap.wsag4j.types.configuration.ConfigurationType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSAG4JConfiguration {
    private static final Logger LOG = Logger.getLogger(WSAG4JConfiguration.class);
    private static WSAG4JConfigurationEnvironment instance = null;

    private static synchronized WSAG4JConfigurationEnvironment getEnvironment() {
        SimpleLog.setLevel((int)3);
        if (instance == null) {
            SPInterface mssConfigSP = WSAG4JConfiguration.getWSAG4JSPI();
            PropertiesHolder pHolder = new PropertiesHolder("wsag4j.properties");
            DefaultClassHolder cHolder = new DefaultClassHolder(WSAG4JEnvironment.class.getName());
            instance = (WSAG4JConfigurationEnvironment)DiscoverSingleton.find(null, (SPInterface)mssConfigSP, (PropertiesHolder)pHolder, (DefaultClassHolder)cHolder);
        }
        return instance;
    }

    private static SPInterface getWSAG4JSPI() {
        ClassLoaders loaders = ClassLoaders.getLibLoaders(WSAG4JConfigurationEnvironment.class, DiscoverClass.class, (boolean)true);
        Properties properties = ResourceUtils.loadProperties(WSAG4JConfigurationEnvironment.class, (String)"wsag4j.properties", (ClassLoaders)loaders);
        if (properties == null) {
            properties = new Properties();
        }
        String cPath = properties.getProperty("wsag4j.configuration.path", "/etc/wsag4j");
        SPInterface mssConfigSP = new SPInterface(WSAG4JConfigurationEnvironment.class, new Class[]{String.class}, new Object[]{cPath});
        return mssConfigSP;
    }

    public static String getConfigurationPath() {
        return WSAG4JConfiguration.getEnvironment().getConfigurationPath();
    }

    public static Object findImplementation(Class<?> interfaceDef, String configFile, String defaultImpl) {
        DiscoverClass discovery = new DiscoverClass();
        try {
            try {
                Properties properties = new Properties();
                InputStream resource = WSAG4JConfiguration.findResource(configFile);
                properties.load(resource);
                Class theClass = discovery.find(interfaceDef, properties, defaultImpl);
                return theClass.newInstance();
            }
            catch (IOException e) {
                String message = "Could not load resource {0}. Try default discovery.";
                LOG.debug((Object)LogMessage.getMessage(message, configFile));
                Class theClass = discovery.find(interfaceDef, configFile, defaultImpl);
                return theClass.newInstance();
            }
        }
        catch (InstantiationException e) {
            String message = "Could not instantiate class for interface {0}.";
            LOG.debug((Object)LogMessage.getMessage("Could not instantiate class for interface {0}.", interfaceDef.getName()), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            String message = "Could not instantiate class for interface {0}.";
            LOG.debug((Object)LogMessage.getMessage("Could not instantiate class for interface {0}.", interfaceDef.getName()), (Throwable)e);
        }
        return null;
    }

    public static Object findSingeltonImplementation(Class<?> interfaceDef, String configFile, String defaultImpl) {
        try {
            Properties properties = new Properties();
            InputStream resource = WSAG4JConfiguration.findResource(configFile);
            properties.load(resource);
            return DiscoverSingleton.find(interfaceDef, (Properties)properties, (String)defaultImpl);
        }
        catch (IOException e) {
            String message = "Could not load resource {0}. Try default discovery.";
            LOG.debug((Object)LogMessage.getMessage("Could not load resource {0}. Try default discovery.", configFile));
            LOG.trace((Object)e);
            return DiscoverSingleton.find(interfaceDef, (String)configFile, (String)defaultImpl);
        }
    }

    public static InputStream findResource(String resourceName) throws IOException {
        return WSAG4JConfiguration.findResource(WSAG4JConfiguration.getEnvironment().getConfigurationPath(), resourceName);
    }

    public static InputStream findResource(String path, String resourceName) throws IOException {
        return WSAG4JConfiguration.findResourceURL(path, resourceName).openStream();
    }

    public static URL findResourceURL(String resourceName) throws IOException {
        return WSAG4JConfiguration.findResourceURL(WSAG4JConfiguration.getEnvironment().getConfigurationPath(), resourceName);
    }

    public static URL findResourceURL(String path, String resourceName) throws IOException {
        URL resourceUrl;
        if (path == null) {
            path = "";
        }
        if (resourceName == null) {
            throw new IOException("Could not find resource. No resource name specified (null).");
        }
        File file = null;
        file = new File(path, resourceName);
        if (file.exists()) {
            try {
                Object[] filler = new Object[]{resourceName, path};
                String message = MessageFormat.format("Found resource {0} in directory {1}.", filler);
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)message);
                }
                return file.toURL();
            }
            catch (IOException e) {
                Object[] filler = new Object[]{resourceName};
                String message = MessageFormat.format("Could not read resource {0}.", filler);
                LOG.error((Object)message, (Throwable)e);
            }
        }
        if ((file = new File(resourceName)).exists()) {
            try {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)MessageFormat.format("Found resource [{0}].", resourceName));
                }
                return file.toURL();
            }
            catch (IOException e) {
                LOG.error((Object)MessageFormat.format("Could not read resource {0}.", resourceName), (Throwable)e);
            }
        }
        String qualifiedResourceName = path + System.getProperty("file.separator") + resourceName;
        if (path.equals("")) {
            qualifiedResourceName = "/" + resourceName;
        }
        if ((resourceUrl = WSAG4JConfiguration.class.getResource(qualifiedResourceName)) != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)MessageFormat.format("Found resource {0} by the classloader [external name: {1}]", qualifiedResourceName, resourceUrl.toExternalForm()));
            }
            return resourceUrl;
        }
        resourceUrl = resourceName.startsWith("/") || resourceName.startsWith("\\") ? WSAG4JConfiguration.class.getResource(resourceName) : WSAG4JConfiguration.class.getResource("/" + resourceName);
        if (resourceUrl != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)MessageFormat.format("Found resource {0} by the classloader [external name: {1}]", resourceName, resourceUrl.toExternalForm()));
            }
            return resourceUrl;
        }
        LOG.error((Object)LogMessage.getMessage("The resource {0} was not found.", resourceName));
        LOG.error((Object)LogMessage.getMessage("Tried the following directories: [{0}] [{1}]", path, System.getProperty("java.class.path")));
        throw new FileNotFoundException(LogMessage.format("The resource [{0}] was not found at the system.", resourceName));
    }

    public static ConfigurationType findWSAG4JConfiguration(String fileName) throws IOException {
        try {
            InputStream resourceInput = WSAG4JConfiguration.findResource(fileName);
            ConfigurationType result = null;
            if (resourceInput != null) {
                try {
                    result = ConfigurationDocument.Factory.parse((InputStream)resourceInput).getConfiguration();
                }
                catch (IOException e) {
                    String msgText = "Error reading the configuration file {0}. Error: {1}";
                    String message = LogMessage.format(msgText, fileName, e.getMessage());
                    LOG.error((Object)message);
                    throw new IOException(message);
                }
                catch (XmlException e) {
                    String msgText = "Error reading the configuration file {0}. Description: {1}";
                    String message = LogMessage.format(msgText, fileName, e.getMessage());
                    LOG.error((Object)message);
                    throw new IOException(message);
                }
            }
            return result;
        }
        catch (Exception ex) {
            String msgText = "Error loading configuration file [{0}]. Message: {1}";
            String message = LogMessage.format(msgText, fileName, ex.getMessage());
            LOG.error((Object)message);
            return null;
        }
    }
}

