/* 
 * Copyright (c) 2007, Fraunhofer-Gesellschaft
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * (1) Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the disclaimer at the end.
 *     Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in
 *     the documentation and/or other materials provided with the
 *     distribution.
 * 
 * (2) Neither the name of Fraunhofer nor the names of its
 *     contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 */
package org.ogf.graap.wsag.api.client;

import java.util.Properties;

import org.ogf.graap.wsag.api.security.ISecurityProperties;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

/**
 * WsClient
 * 
 * @author Oliver Waeldrich
 */
public interface WsClient
{

    /**
     * Returns the security properties used by the web-service client.
     * 
     * @return the security properties for this client
     */
    ISecurityProperties getSecurityProperties();

    /**
     * Returns the properties used by the web-service client.
     * 
     * @return a list of properties associated with the client
     */
    Properties getProperties();

    /**
     * Sets the properties used for the web-service client.
     * 
     * @param properties
     *            Sets the properties for this client
     */
    void setProperties( Properties properties );

    /**
     * Returns the endpoint of the client instance.
     * 
     * @return Returns the endpoint reference for this WS resource.
     */
    EndpointReferenceType getEndpoint();

    /**
     * Determines whether or not a client prints the web-service messages to the console.
     * 
     * @return true, if the web service client traces the incoming/outgoing messages.
     */
    boolean isUsingTrace();

    /**
     * Sets the clients trace mode.
     * 
     * @param trace
     *            true, if the web service client should traces incoming/outgoing messages.
     */
    void setTrace( boolean trace );

}
