/*
 * Decompiled with CFR 0.152.
 */
package de.tsl2.nano.util.operation;

import de.tsl2.nano.action.IAction;
import de.tsl2.nano.core.log.LogFactory;
import de.tsl2.nano.core.util.CollectionUtil;
import de.tsl2.nano.core.util.StringUtil;
import de.tsl2.nano.core.util.Util;
import de.tsl2.nano.util.operation.IConverter;
import de.tsl2.nano.util.parser.Parser;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.simpleframework.xml.Default;
import org.simpleframework.xml.DefaultType;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementMap;
import org.simpleframework.xml.core.Persist;

@Default(value=DefaultType.FIELD, required=false)
public abstract class Operator<INPUT, OUTPUT>
extends Parser<INPUT> {
    private static final Log LOG = LogFactory.getLog(Operator.class);
    @Element(required=false)
    Class<? extends INPUT> inputType;
    @ElementMap(inline=true, required=false)
    Map<String, INPUT> syntax;
    private transient Map<INPUT, OUTPUT> values;
    transient IConverter<INPUT, OUTPUT> converter;
    transient Map<INPUT, IAction<OUTPUT>> operationDefs;
    transient boolean explizitXml = false;
    public static final String KEY_BEGIN = "begin";
    public static final String KEY_END = "end";
    public static final String KEY_TERM = "term";
    public static final String KEY_TERM_ENCLOSED = "term.enclosed";
    public static final String KEY_BETWEEN = "between";
    public static final String KEY_CONCAT = "concat";
    public static final String KEY_OPERATION = "operation";
    public static final String KEY_HIGH_OPERATION = "high.operation";
    public static final String KEY_OPERAND = "operand";
    public static final String KEY_EMPTY = "empty";
    public static final String KEY_RESULT = "result";

    public Operator() {
        this(null, null, null);
    }

    public Operator(Class<? extends INPUT> inputClass, IConverter<INPUT, OUTPUT> converter, Map<INPUT, OUTPUT> values) {
        this.inputType = inputClass != null ? inputClass : String.class;
        this.converter = converter;
        this.values = values != null ? values : new HashMap();
        this.syntax = this.createSyntax();
        this.createOperations();
        this.createTermSyntax();
    }

    protected abstract Map<String, INPUT> createSyntax();

    protected final INPUT syntax(String key) {
        return this.syntax.get(key);
    }

    protected abstract void createOperations();

    protected abstract void createTermSyntax();

    protected void addOperation(INPUT operator, IAction<OUTPUT> operation) {
        this.operationDefs.put(operator, operation);
    }

    protected boolean resultEstablished() {
        return this.values.containsKey(KEY_RESULT);
    }

    public Map<INPUT, OUTPUT> getValues() {
        return this.values;
    }

    public void reset() {
        this.getValues().clear();
    }

    public OUTPUT eval(INPUT expression, Map<INPUT, OUTPUT> v) {
        if (this.values == null) {
            this.values = new HashMap<INPUT, OUTPUT>();
        }
        this.values.putAll(v);
        return this.eval(expression);
    }

    public OUTPUT eval(INPUT expression) {
        try {
            OUTPUT result;
            INPUT term;
            expression = this.wrap(expression);
            expression = this.encloseInBrackets(expression);
            if (LOG.isDebugEnabled()) {
                String log = "\n-------------------------------------------------------------------------------\n  OPERATION: " + expression + "\n  PARAMETER: " + this.values + "\n";
                LOG.debug((Object)log);
            }
            while (!(this.values.containsKey(KEY_RESULT) || this.isEmpty(term = this.extract(expression, this.syntax(KEY_TERM_ENCLOSED))) && this.isEmpty(term = this.extract(expression, this.syntax(KEY_TERM))))) {
                INPUT t = this.extract(term, this.syntax(KEY_TERM));
                boolean finish = this.unwrap(expression).equals(term);
                this.replace(expression, term, this.converter.from(this.operate(this.wrap(t), this.values)));
                if (!finish) continue;
                break;
            }
            if (this.resultEstablished()) {
                result = this.getValue(KEY_RESULT);
            } else {
                INPUT operand = this.extract(expression, this.syntax.get(KEY_OPERAND));
                result = this.getValue(operand);
                if (this.isEmpty(expression)) {
                    expression = operand;
                }
                OUTPUT OUTPUT = result = result != null ? result : this.converter.to(this.trim(expression));
            }
            if (LOG.isDebugEnabled()) {
                String log = "  RESULT: " + result + "\n-------------------------------------------------------------------------------\n";
                LOG.debug((Object)log);
            }
            return result;
        }
        catch (Exception ex) {
            String msg = Util.toString(this.getClass(), (Object[])new Object[]{"expression=" + expression, "value=", this.values});
            throw new IllegalStateException("Error on evaluation of operation '" + msg + "'", ex);
        }
    }

    protected OUTPUT getValue(Object key) {
        return this.values.get(key);
    }

    protected void addValue(INPUT key, OUTPUT value) {
        this.getValues().put(key, value);
    }

    protected INPUT encloseInBrackets(INPUT expression) {
        INPUT toEnclose;
        INPUT term = this.wrap(this.syntax.get(KEY_TERM));
        this.replace(term, this.syntax.get(KEY_OPERATION), this.syntax.get(KEY_HIGH_OPERATION));
        Object notEnclosed = this.concat(term, this.syntax.get(KEY_OPERATION), this.syntax.get(KEY_OPERAND));
        INPUT highOp = this.syntax.get(KEY_HIGH_OPERATION);
        while (!this.isEmpty(toEnclose = this.extract(expression, notEnclosed))) {
            INPUT t = this.extract(toEnclose, term);
            if (this.extract(t, highOp) == null) continue;
            this.replace(expression, t, this.concat(this.syntax.get(KEY_BEGIN), t, this.syntax.get(KEY_END)));
        }
        return expression;
    }

    protected OUTPUT operate(INPUT term, Map<INPUT, OUTPUT> values) {
        if (this.resultEstablished()) {
            this.replace(term, term, this.syntax(KEY_EMPTY));
            return this.getValue(KEY_RESULT);
        }
        Operation op = new Operation(term);
        OUTPUT n1 = this.getValue(op.o1());
        n1 = n1 != null || this.isEmpty(op.o2()) ? n1 : this.newOperand(op.o1());
        OUTPUT n2 = this.getValue(op.o2());
        n2 = n2 != null || this.isEmpty(op.o2()) ? n2 : this.newOperand(op.o2());
        IAction<OUTPUT> operation = this.operationDefs.get(op.op());
        if (operation == null) {
            throw new IllegalArgumentException(term.toString() + " (operation should match: " + this.syntax(KEY_OPERATION) + ")");
        }
        operation.setParameter(new Object[]{n1, n2});
        Object result = operation.activate();
        if (!this.isEmpty(term)) {
            term = this.concat(this.converter.from(result), term);
            result = this.operate(this.wrap(term), values);
        }
        return (OUTPUT)result;
    }

    protected OUTPUT newOperand(INPUT expr) {
        return this.converter.to(expr);
    }

    @Persist
    void initSerialization() {
        if (!this.explizitXml) {
            this.syntax = null;
            this.inputType = null;
        }
    }

    public String toString() {
        return "Operator(possible operations: " + StringUtil.toFormattedString(this.operationDefs, (int)1000);
    }

    class Operation {
        INPUT[] op;
        public static final int MODE_INFIX = 0;
        public static final int MODE_PREFIX = 1;
        public static final int MODE_POSTFIX = 2;

        public Operation(INPUT term) {
            this.op = this.extractOperation(term, 0);
        }

        public Operation(INPUT term, int mode) {
            this.op = this.extractOperation(term, mode);
        }

        protected INPUT[] extractOperation(INPUT term, int mode) {
            Object[] OP = (Object[])Array.newInstance(Operator.this.inputType, 3);
            Object empty = Operator.this.syntax(Operator.KEY_EMPTY);
            Object sOpd = Operator.this.syntax(Operator.KEY_OPERAND);
            Object sOpt = Operator.this.syntax(Operator.KEY_OPERATION);
            OP[mode == 1 ? 1 : 0] = Operator.this.extract(term, mode == 1 ? sOpt : sOpd, empty);
            OP[mode == 0 ? 1 : (mode == 2 ? 2 : 0)] = Operator.this.extract(term, mode == 0 ? sOpt : sOpd, empty);
            OP[mode == 2 ? 1 : 2] = Operator.this.extract(term, mode == 2 ? sOpt : sOpd, empty);
            if (mode == 0 && Operator.this.isEmpty(OP[2])) {
                CollectionUtil.swap((Object[])OP, (int)0, (int)2);
            }
            return OP;
        }

        public INPUT o1() {
            return this.op[0];
        }

        public INPUT op() {
            return this.op[1];
        }

        public INPUT o2() {
            return this.op[2];
        }

        public String toString() {
            return "" + this.op[0] + this.op[1] + this.op[2];
        }
    }
}

