/*
 * Decompiled with CFR 0.152.
 */
package de.tsl2.nano.util.operation;

import de.tsl2.nano.util.operation.IConverter;
import de.tsl2.nano.util.operation.IOperable;

public class Operable<T extends Comparable<T>>
implements IOperable<T> {
    IConverter<T, Number> converter;
    T value;

    public Operable(T value, IConverter<T, Number> converter) {
        this.value = value;
        this.converter = converter;
    }

    @Override
    public boolean isLower(T operand) {
        return this.value.compareTo(operand) < 0;
    }

    @Override
    public boolean isGreater(T operand) {
        return this.value.compareTo(operand) > 0;
    }

    @Override
    public T min(T operand) {
        return this.isLower(operand) ? this.value : operand;
    }

    @Override
    public T max(T operand) {
        return this.isGreater(operand) ? this.value : operand;
    }

    @Override
    public T getDiff(T operand) {
        this.checkConverter();
        return (T)((Comparable)this.converter.from(this.getDelta(operand)));
    }

    protected double getDelta(T operand) {
        return this.converter.to(this.value).doubleValue() - this.converter.to(operand).doubleValue();
    }

    protected double getSum(T operand) {
        return this.converter.to(this.value).doubleValue() + this.converter.to(operand).doubleValue();
    }

    protected double getMultiplication(T operand) {
        return this.converter.to(this.value).doubleValue() * this.converter.to(operand).doubleValue();
    }

    protected double getDivision(T operand) {
        return this.converter.to(this.value).doubleValue() / this.converter.to(operand).doubleValue();
    }

    @Override
    public T subtract(T operand) {
        this.checkConverter();
        return (T)((Comparable)this.converter.from(this.getDelta(operand)));
    }

    @Override
    public T add(T operand) {
        this.checkConverter();
        return (T)((Comparable)this.converter.from(this.getSum(operand)));
    }

    @Override
    public T multiply(T operand) {
        this.checkConverter();
        return (T)((Comparable)this.converter.from(this.getMultiplication(operand)));
    }

    @Override
    public T divide(T operand) {
        this.checkConverter();
        return (T)((Comparable)this.converter.from(this.getDivision(operand)));
    }

    @Override
    public T getValue() {
        return this.value;
    }

    public Number getConversion() {
        this.checkConverter();
        return this.converter.to(this.value);
    }

    protected void checkConverter() {
        if (this.converter == null) {
            throw new UnsupportedOperationException("without converter, this operation is undefined!");
        }
    }
}

