/*
 * Decompiled with CFR 0.152.
 */
package de.tsl2.nano.util.operation;

import de.tsl2.nano.action.CommonAction;
import de.tsl2.nano.util.operation.FromCharSequenceConverter;
import de.tsl2.nano.util.operation.IConverter;
import de.tsl2.nano.util.operation.SOperator;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;

public class NumericOperator
extends SOperator<BigDecimal> {
    public NumericOperator() {
        this(null);
    }

    public NumericOperator(Map<CharSequence, BigDecimal> values) {
        super((Class<? extends CharSequence>)CharSequence.class, NumericOperator.createConverter(), values);
    }

    protected static IConverter<CharSequence, BigDecimal> createConverter() {
        DecimalFormat fmt = (DecimalFormat)NumberFormat.getInstance();
        fmt.setParseBigDecimal(true);
        return new FromCharSequenceConverter<BigDecimal>(fmt);
    }

    @Override
    protected void createOperations() {
        this.syntax.put("operation", "[-+*/%^]");
        this.syntax.put("high.operation", "[*/%^]");
        this.operationDefs = new HashMap();
        this.addOperation("+", new CommonAction<BigDecimal>(){

            public BigDecimal action() throws Exception {
                return ((BigDecimal)this.parameters().getValue(0)).add((BigDecimal)this.parameters().getValue(1));
            }
        });
        this.addOperation("-", new CommonAction<BigDecimal>(){

            public BigDecimal action() throws Exception {
                return ((BigDecimal)this.parameters().getValue(0)).subtract((BigDecimal)this.parameters().getValue(1));
            }
        });
        this.addOperation("*", new CommonAction<BigDecimal>(){

            public BigDecimal action() throws Exception {
                return ((BigDecimal)this.parameters().getValue(0)).multiply((BigDecimal)this.parameters().getValue(1));
            }
        });
        this.addOperation("/", new CommonAction<BigDecimal>(){

            public BigDecimal action() throws Exception {
                return ((BigDecimal)this.parameters().getValue(0)).divide((BigDecimal)this.parameters().getValue(1));
            }
        });
        this.addOperation("%", new CommonAction<BigDecimal>(){

            public BigDecimal action() throws Exception {
                return new BigDecimal(((BigDecimal)this.parameters().getValue(0)).intValueExact() % ((BigDecimal)this.parameters().getValue(1)).intValueExact());
            }
        });
        this.addOperation("^", new CommonAction<BigDecimal>(){

            public BigDecimal action() throws Exception {
                return ((BigDecimal)this.parameters().getValue(0)).pow(((BigDecimal)this.parameters().getValue(1)).intValueExact());
            }
        });
    }
}

