/*
 * Decompiled with CFR 0.152.
 */
package de.tsl2.nano.util.operation;

import de.tsl2.nano.core.ENV;
import de.tsl2.nano.core.util.RegExUtil;
import de.tsl2.nano.util.operation.ConditionOperator;
import de.tsl2.nano.util.operation.Function;
import de.tsl2.nano.util.operation.NumericOperator;
import de.tsl2.nano.util.operation.TypeOP;
import java.math.BigDecimal;
import java.util.Map;

public class NumericConditionOperator
extends ConditionOperator<Object> {
    transient Function<Object> funcop = (Function)ENV.get(Function.class);

    @Override
    protected CharSequence precalc(CharSequence expression) {
        expression = this.wrap(expression);
        this.funcop.eval(expression, this.getValues());
        return super.precalc(expression);
    }

    @Override
    public BigDecimal eval(CharSequence expression, Map<CharSequence, Object> v) {
        Object result = super.eval(this.wrap(expression), v);
        return (BigDecimal)(result instanceof BigDecimal ? result : (result != null && !result.equals("null") ? new BigDecimal(result.toString().trim()) : null));
    }

    @Override
    protected void createOperations() {
        super.createOperations();
        this.syntax.put("operation", RegExUtil.any((CharSequence[])new CharSequence[]{"[\\-+*/%^]", (CharSequence)this.syntax.get("operation")}));
        this.syntax.put("high.operation", "[*/%^]");
        NumericOperator nop = new NumericOperator();
        this.addOperation("+", new TypeOP<BigDecimal>(nop, BigDecimal.class, "+"));
        this.addOperation("-", new TypeOP<BigDecimal>(nop, BigDecimal.class, "-"));
        this.addOperation("*", new TypeOP<BigDecimal>(nop, BigDecimal.class, "*"));
        this.addOperation("/", new TypeOP<BigDecimal>(nop, BigDecimal.class, "/"));
        this.addOperation("%", new TypeOP<BigDecimal>(nop, BigDecimal.class, "%"));
        this.addOperation("^", new TypeOP<BigDecimal>(nop, BigDecimal.class, "^"));
    }
}

