/*
 * Decompiled with CFR 0.152.
 */
package de.tsl2.nano.util.operation;

import de.tsl2.nano.core.cls.BeanClass;
import de.tsl2.nano.core.log.LogFactory;
import de.tsl2.nano.core.util.FormatUtil;
import de.tsl2.nano.core.util.NumberUtil;
import de.tsl2.nano.core.util.Util;
import de.tsl2.nano.util.operation.FunctionContainer;
import de.tsl2.nano.util.parser.SParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.simpleframework.xml.Default;
import org.simpleframework.xml.DefaultType;
import org.simpleframework.xml.ElementArray;

@Default(value=DefaultType.FIELD, required=false)
public class Function<OUTPUT>
extends SParser {
    private static final Log LOG = LogFactory.getLog(Function.class);
    @ElementArray(name="function-container")
    List<FunctionContainer> funcContainer;
    static final String FUNC_BEGIN = "\\(";
    static final String FUNC_NAME = "(\\w+)";
    static final String FUNC_END = "\\)";
    static final String FUNC_ARG = "(\\s*\\w+\\s*[,]?)";

    Function() {
    }

    public OUTPUT eval(CharSequence expression, Map<CharSequence, Object> values) {
        Object result;
        Object res = null;
        expression = this.wrap(expression);
        while (!this.isEmpty(expression)) {
            CharSequence func;
            while (this.isEmpty(func = (CharSequence)this.extract(expression, "(\\w+)\\((\\s*\\w+\\s*[,]?)*\\)")) && !this.isEmpty(this.extract(expression, "(\\w+)\\(", ""))) {
            }
            if (this.isEmpty(func)) break;
            res = this.calc(func, values);
            values.put(func, res);
            this.replace(expression, func, res != null ? FormatUtil.getDefaultFormat(res, (boolean)false).format(res) : "");
        }
        return (OUTPUT)((result = values.get(expression)) != null ? result : (res != null ? res : expression));
    }

    private OUTPUT calc(CharSequence func, Map<CharSequence, Object> values) {
        CharSequence f = this.wrap(func);
        CharSequence name = this.extract(f, FUNC_NAME, "");
        ArrayList<Object> argList = new ArrayList<Object>();
        CharSequence p = f;
        while (!this.isEmpty(p = this.extract(f, "\\w+", ""))) {
            if (NumberUtil.isNumber((Object)p.toString())) {
                argList.add(NumberUtil.getBigDecimal((String)p.toString()).doubleValue());
                continue;
            }
            argList.add(values.get(p));
        }
        Object result = null;
        if (this.funcContainer == null) {
            this.funcContainer = Arrays.asList(new FunctionContainer(Math.class, Double.TYPE, true, new String[0]));
        }
        boolean funcFound = false;
        for (FunctionContainer fc : this.funcContainer) {
            if (!fc.hasMethod(name)) continue;
            try {
                Object[] args = fc.argType != null ? Util.convertAll(fc.argType, (Object[])argList.toArray()) : argList.toArray();
                result = BeanClass.call((Class)fc.funcClass, (String)name.toString(), (boolean)fc.usePrimitives, (Object[])args);
                LOG.info((Object)(func + " = " + result + " [with " + values + "]"));
                funcFound = true;
                break;
            }
            catch (Exception exception) {
            }
        }
        if (!funcFound) {
            throw new IllegalArgumentException("function " + func + " is not defined!");
        }
        return (OUTPUT)result;
    }

    private Object[] getArgs(List<String> pars, Map<CharSequence, Object> values) {
        Object[] args = new Object[pars.size()];
        int i = 0;
        for (String p : pars) {
            args[i++] = values.get(p);
        }
        return args;
    }
}

