/*
 * Decompiled with CFR 0.152.
 */
package de.tsl2.nano.util.operation;

import de.tsl2.nano.action.CommonAction;
import de.tsl2.nano.action.IAction;
import de.tsl2.nano.core.util.StringUtil;
import de.tsl2.nano.core.util.Util;
import de.tsl2.nano.util.operation.BooleanOperator;
import de.tsl2.nano.util.operation.FromCharSequenceConverter;
import de.tsl2.nano.util.operation.IConverter;
import de.tsl2.nano.util.operation.SOperator;
import de.tsl2.nano.util.operation.TypeOP;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.Map;

public class ConditionOperator<T>
extends SOperator<T> {
    private transient BooleanOperator op;
    public static final String KEY_THEN = "?";
    public static final String KEY_ELSE = ":";
    public static final String KEY_EQUALS = "=";
    public static final String KEY_ANY = ".+";

    public ConditionOperator() {
        this(null);
    }

    public ConditionOperator(Map<CharSequence, T> values) {
        super((Class<? extends CharSequence>)String.class, null, values);
        this.op = new BooleanOperator(values);
        this.converter = this.createConverter();
    }

    protected BooleanOperator getOp() {
        if (this.op == null) {
            this.op = new BooleanOperator(this.getValues());
        }
        return this.op;
    }

    protected IConverter<CharSequence, T> createConverter() {
        Format fmt = new Format(){

            @Override
            public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
                return toAppendTo.append(StringUtil.toString((Object)obj));
            }

            @Override
            public Object parseObject(String source, ParsePosition pos) {
                pos.setIndex(Util.isEmpty((Object)source) ? 1 : source.length());
                Boolean b = Boolean.valueOf(source);
                return b.toString().equals(source) ? b : source;
            }
        };
        return new FromCharSequenceConverter(fmt);
    }

    @Override
    protected void createOperations() {
        this.syntax.put("operation", "[!&|?:=]");
        this.operationDefs = new HashMap();
        this.addOperation(KEY_THEN, new CommonAction<T>(){

            public T action() throws Exception {
                boolean result = this.parameters().getValue(0) instanceof Boolean ? ((Boolean)this.parameters().getValue(0)).booleanValue() : ((Boolean)ConditionOperator.this.op.eval((String)this.parameters().getValue(0))).booleanValue();
                return ConditionOperator.this.executeIf(this.parameters().getValue(1), result);
            }
        });
        this.addOperation(KEY_ELSE, new CommonAction<T>(){

            public T action() throws Exception {
                boolean result = this.parameters().getValue(0) instanceof Boolean ? ((Boolean)this.parameters().getValue(0)).booleanValue() : ((Boolean)ConditionOperator.this.op.eval((String)this.parameters().getValue(0))).booleanValue();
                return ConditionOperator.this.executeIf(this.parameters().getValue(1), !result);
            }
        });
        this.addOperation(KEY_EQUALS, new CommonAction<T>(){

            public T action() throws Exception {
                return Util.untyped((Object)Util.equals((Object[])this.parameter.getValues()));
            }
        });
        this.addOperation("&", new TypeOP<Boolean>(this.getOp(), Boolean.class, "&"));
        this.addOperation("|", new TypeOP<Boolean>(this.getOp(), Boolean.class, "|"));
        this.addOperation("!", new TypeOP<Boolean>(this.getOp(), Boolean.class, "!"));
    }

    private T executeIf(T p, boolean iF) {
        Object result;
        if (iF) {
            result = p instanceof IAction ? ((IAction)p).activate() : (p instanceof CharSequence && ((CharSequence)p).toString().matches(KEY_ANY + this.syntax("operation") + KEY_ANY) ? this.op.eval((CharSequence)p) : p);
            this.addValue("result", result);
        } else {
            result = Boolean.FALSE;
        }
        return (T)result;
    }

    @Override
    public T eval(CharSequence expression) {
        CharSequence ifCond = this.subElement(expression, null, KEY_THEN, false);
        if (!this.isEmpty(ifCond) && !ifCond.equals(expression.toString())) {
            boolean ifTrue;
            CharSequence ifCondSub;
            CharSequence prefix = this.subElement(ifCond, null, (CharSequence)this.syntax.get("begin"), true);
            if (prefix.equals(ifCondSub = this.subElement(ifCond, (CharSequence)this.syntax.get("begin"), (CharSequence)this.syntax.get("end"), true))) {
                prefix = (CharSequence)this.syntax.get("empty");
            }
            if (!(ifTrue = ((Boolean)this.op.eval(ifCondSub, this.getValues())).booleanValue())) {
                ifTrue = (Boolean)this.op.eval(ifCond, this.getValues());
            }
            return ifTrue ? this.eval(this.concat(prefix, this.subEnclosing(expression, KEY_THEN, KEY_ELSE))) : this.eval(this.concat(prefix, this.subEnclosing(expression, KEY_ELSE, null)));
        }
        return (T)super.eval(this.precalc(expression));
    }

    protected CharSequence precalc(CharSequence expression) {
        return expression;
    }
}

