/*
 * Decompiled with CFR 0.152.
 */
package de.tsl2.nano.util.operation;

import de.tsl2.nano.util.operation.IConverter;
import de.tsl2.nano.util.operation.IRange;
import de.tsl2.nano.util.operation.Range;
import java.io.Serializable;

public class CRange<T extends Comparable<T>>
extends Range<T>
implements Comparable<CRange<T>>,
Serializable,
IRange<T> {
    private static final long serialVersionUID = 8470377216770952614L;
    IConverter<T, Number> converter;

    public <C extends IConverter<T, Number>> CRange(T from, T to, C converter) {
        super(from, to);
        this.converter = converter;
    }

    @Override
    public int compareTo(CRange<T> o) {
        if (((Comparable)this.getFrom()).compareTo(o.getFrom()) == 0) {
            return ((Comparable)this.getTo()).compareTo(o.getTo());
        }
        return ((Comparable)this.getFrom()).compareTo(o.getFrom());
    }

    public Number getDelta() {
        return this.converter.to(this.to).doubleValue() - this.converter.to(this.from).doubleValue();
    }

    public boolean contains(T another) {
        return this.contains(new CRange<T>(another, another, this.converter));
    }

    public boolean contains(IRange<T> another) {
        if (another == null) {
            return false;
        }
        Comparable start = this.getFrom() != null ? (Comparable)this.getFrom() : (Comparable)this.converter.from(Long.MIN_VALUE);
        Comparable end = this.getTo() != null ? (Comparable)this.getTo() : (Comparable)this.converter.from(Long.MAX_VALUE);
        Comparable astart = another.getFrom() != null ? (Comparable)another.getFrom() : (Comparable)this.converter.from(Long.MIN_VALUE);
        Comparable aend = another.getTo() != null ? (Comparable)another.getTo() : (Comparable)this.converter.from(Long.MAX_VALUE);
        return start.compareTo(aend) <= 0 && end.compareTo(astart) >= 0;
    }

    public boolean intersects(IRange<T> range) {
        return this.intersects((Comparable)range.getFrom(), (Comparable)range.getTo());
    }

    public boolean intersects(T from, T to) {
        return ((Comparable)this.getTo()).compareTo(from) >= 0 && ((Comparable)this.getFrom()).compareTo(to) <= 0;
    }
}

