/*
 * Decompiled with CFR 0.152.
 */
package de.tsl2.nano.util.operation;

import de.tsl2.nano.action.CommonAction;
import de.tsl2.nano.core.util.Util;
import de.tsl2.nano.util.operation.FromCharSequenceConverter;
import de.tsl2.nano.util.operation.IConverter;
import de.tsl2.nano.util.operation.SOperator;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.Map;

public class BooleanOperator
extends SOperator<Boolean> {
    public BooleanOperator() {
    }

    public BooleanOperator(Map<CharSequence, Boolean> values) {
        super((Class<? extends CharSequence>)CharSequence.class, BooleanOperator.createConverter(), values);
    }

    protected static IConverter<CharSequence, Boolean> createConverter() {
        Format fmt = new Format(){

            @Override
            public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
                return toAppendTo.append(((Boolean)obj).toString());
            }

            @Override
            public Object parseObject(String source, ParsePosition pos) {
                pos.setIndex(Util.isEmpty((Object)source) ? 1 : source.length());
                return Boolean.valueOf(source);
            }
        };
        return new FromCharSequenceConverter<Boolean>(fmt);
    }

    @Override
    protected void createOperations() {
        this.syntax.put("operation", "[!&|=]");
        this.operationDefs = new HashMap();
        this.addOperation("&", new CommonAction<Boolean>(){

            public Boolean action() throws Exception {
                return (Boolean)this.parameters().getValue(0) & (Boolean)this.parameters().getValue(1);
            }
        });
        this.addOperation("|", new CommonAction<Boolean>(){

            public Boolean action() throws Exception {
                return (Boolean)this.parameters().getValue(0) | (Boolean)this.parameters().getValue(1);
            }
        });
        this.addOperation("!", new CommonAction<Boolean>(){

            public Boolean action() throws Exception {
                return (Boolean)this.parameters().getValue(1) == false;
            }
        });
        this.addOperation("=", new CommonAction<Boolean>(){

            public Boolean action() throws Exception {
                return Util.equals((Object[])this.parameter.getValues());
            }
        });
    }
}

