/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testng.databinding.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import net.sf.testng.databinding.util.MethodParameter;

public class Types {
    private Types() {
    }

    public static boolean isEnumType(Type type) {
        return type instanceof Class && ((Class)type).isEnum();
    }

    public static boolean isPrimitiveType(Type type) {
        if (type instanceof Class) {
            return type == String.class || type == Integer.class || type == Integer.TYPE || type == Long.class || type == Long.TYPE || type == Float.class || type == Float.TYPE || type == Double.class || type == Double.TYPE || type == Boolean.class || type == Boolean.TYPE || type == Character.class || type == Character.TYPE;
        }
        return false;
    }

    public static boolean isSingleBeanType(Type type) {
        return type instanceof Class && !Types.isPrimitiveType(type) && !Types.isEnumType(type);
    }

    public static boolean isListOfPrimitivesType(Type type) {
        ParameterizedType paramType;
        return type instanceof ParameterizedType && (paramType = (ParameterizedType)type).getRawType() == List.class && paramType.getActualTypeArguments().length > 0 && Types.isPrimitiveType(paramType.getActualTypeArguments()[0]);
    }

    public static boolean isListOfBeansType(Type type) {
        ParameterizedType paramType;
        return type instanceof ParameterizedType && (paramType = (ParameterizedType)type).getRawType() == List.class && paramType.getActualTypeArguments().length > 0 && Types.isSingleBeanType(paramType.getActualTypeArguments()[0]);
    }

    public static boolean isSingleObjectType(Type type) {
        return Types.isPrimitiveType(type) || Types.isSingleBeanType(type) || Types.isEnumType(type);
    }

    public static boolean isListOfObjectsType(Type type) {
        return Types.isListOfPrimitivesType(type) || Types.isListOfBeansType(type);
    }

    public static boolean isSupportedType(Type type) {
        return Types.isSingleObjectType(type) || Types.isListOfObjectsType(type);
    }

    public static boolean requiresName(Type type) {
        return Types.isPrimitiveType(type) || Types.isListOfPrimitivesType(type);
    }

    public static MethodParameter unwrapIfPossible(MethodParameter parameter) {
        Type type = parameter.getType();
        if (Types.isSingleObjectType(type)) {
            return parameter;
        }
        if (Types.isListOfObjectsType(type)) {
            List annotations = parameter.getAnnotations();
            type = ((ParameterizedType)type).getActualTypeArguments()[0];
            String name = parameter.getName();
            return new MethodParameter(annotations, type, name);
        }
        throw new IllegalArgumentException();
    }
}

