/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testng.databinding.error;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ErrorCollector {
    private final Type targetType;
    private final String targetName;
    private final List<String> errors = new ArrayList<String>();

    public ErrorCollector(String targetName) {
        this(null, targetName);
    }

    public ErrorCollector(Type targetType) {
        this(targetType, null);
    }

    public ErrorCollector(Type targetType, String targetName) {
        this.targetType = targetType;
        this.targetName = targetName;
    }

    public void addError(String error) {
        this.errors.add(error);
    }

    public Type getTargetType() {
        return this.targetType;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public List<String> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public String toString() {
        String string = "Errors";
        if (this.targetType == null && this.targetName != null) {
            string = string + " for " + this.targetName;
        } else if (this.targetType != null) {
            string = string + " for type: " + this.targetType;
            if (this.targetName != null) {
                string = string + "(named '" + this.targetName + "')";
            }
        }
        return string + ": " + this.errors;
    }
}

