/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testng.databinding;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import net.sf.extcos.ComponentQuery;
import net.sf.extcos.ComponentScanner;
import net.sf.extcos.selector.StoreBinding;
import net.sf.testng.databinding.DataProperties;
import net.sf.testng.databinding.DataProviderStrategy;
import net.sf.testng.databinding.DataProviderStrategyNames;
import net.sf.testng.databinding.TestInput;
import net.sf.testng.databinding.TestOutput;
import net.sf.testng.databinding.error.ErrorCollector;
import net.sf.testng.databinding.error.MissingPropertiesException;
import net.sf.testng.databinding.error.MultipleConfigurationErrorsException;
import net.sf.testng.databinding.error.UnsupportedDataProviderStrategyException;
import net.sf.testng.databinding.properties.DoNothingPropertiesPrefixPreprocessor;
import net.sf.testng.databinding.properties.PropertiesPrefixPreprocessor;
import net.sf.testng.databinding.util.Annotations;
import net.sf.testng.databinding.util.ConstructorMatcher;
import net.sf.testng.databinding.util.Constructors;
import net.sf.testng.databinding.util.MethodParameter;
import net.sf.testng.databinding.util.MethodParametersAndPropertiesConstructorMatcher;
import net.sf.testng.databinding.util.PropertiesUtil;
import net.sf.testng.databinding.util.Types;
import org.testng.annotations.DataProvider;

public class GenericDataProvider {
    private static DataProviderStrategiesMap strategies;

    private GenericDataProvider() {
    }

    private static DataProviderStrategiesMap getStrategies() {
        if (strategies == null) {
            strategies = new DataProviderStrategiesMap();
            final HashSet classes = new HashSet();
            ComponentScanner scanner = new ComponentScanner();
            scanner.getClasses(new ComponentQuery(){

                protected void query() {
                    this.select().from(new String[]{"net.sf.testng.databinding"}).andStore(new StoreBinding[]{this.thoseImplementing(DataProviderStrategy.class).into(classes)}).returning(this.none());
                }
            });
            for (Class clazz : classes) {
                if (clazz.isAnnotationPresent(DataProviderStrategyNames.class)) {
                    DataProviderStrategyNames names = clazz.getAnnotation(DataProviderStrategyNames.class);
                    for (String name : names.value()) {
                        strategies.put(name, clazz);
                    }
                    continue;
                }
                strategies.put(clazz.getSimpleName(), clazz);
            }
        }
        return strategies;
    }

    @DataProvider(name="DataProvider")
    public static Iterator<Object[]> getDataProvider(Method method) throws Exception {
        List<MethodParameter> parameters = GenericDataProvider.createMethodParameters(method);
        GenericDataProvider.checkConfiguration(parameters);
        Class<?> declaringClass = method.getDeclaringClass();
        String propertiesPrefix = method.getName();
        if (method.isAnnotationPresent(DataProperties.class)) {
            DataProperties dp = method.getAnnotation(DataProperties.class);
            if (dp.declaringClass() != Object.class && dp.declaringClass() != declaringClass) {
                declaringClass = dp.declaringClass();
            }
            if (dp.propertiesPrefix() != propertiesPrefix) {
                propertiesPrefix = dp.propertiesPrefix();
            }
            if (dp.prefixPreprocessor() != DoNothingPropertiesPrefixPreprocessor.class) {
                PropertiesPrefixPreprocessor preprocessor = dp.prefixPreprocessor().newInstance();
                propertiesPrefix = preprocessor.process(propertiesPrefix);
            }
        }
        propertiesPrefix = propertiesPrefix + ".";
        Properties dataProperties = GenericDataProvider.loadDataProperties(declaringClass, propertiesPrefix);
        GenericDataProvider.checkProperties(dataProperties);
        return GenericDataProvider.getDataProvider(parameters, dataProperties);
    }

    private static void checkConfiguration(List<MethodParameter> parameters) {
        ArrayList<ErrorCollector> errorCollectors = new ArrayList<ErrorCollector>();
        if (parameters.size() == 0) {
            ErrorCollector errorCollector = new ErrorCollector("no parameters");
            errorCollector.addError("The method has no parameters to feed data into.");
            errorCollectors.add(errorCollector);
        }
        for (MethodParameter parameter : parameters) {
            Type type = parameter.getType();
            ErrorCollector errorCollector = new ErrorCollector(type);
            for (Annotation annotation : parameter.getAnnotations()) {
                if (annotation instanceof TestInput) {
                    if (!Types.isSupportedType(type)) {
                        errorCollector.addError("Unsupported type.");
                        continue;
                    }
                    if (!Types.requiresName(type) || !Annotations.nameNotSet(annotation)) continue;
                    errorCollector.addError("No name set. You need to set the name attribute of the @TestInput annotation of this parameter.");
                    continue;
                }
                if (annotation instanceof TestOutput) {
                    if (!Types.isSupportedType(type)) {
                        errorCollector.addError("Unsupported type.");
                        continue;
                    }
                    if (!Types.requiresName(type) || !Annotations.nameNotSet(annotation)) continue;
                    errorCollector.addError("No name set. You need to set the name attribute of the @TestOutput annotation of this parameter.");
                    continue;
                }
                errorCollector.addError("No data type annotation given. This parameter must either be annotated with @TestInput or @TestOutput.");
            }
            if (!errorCollector.hasErrors()) continue;
            errorCollectors.add(errorCollector);
        }
        if (errorCollectors.size() > 0) {
            throw new MultipleConfigurationErrorsException(errorCollectors);
        }
    }

    private static Properties loadDataProperties(Class<?> declaringClass, String propertiesPrefix) throws Exception {
        Properties properties = new Properties();
        properties.load(declaringClass.getResourceAsStream(GenericDataProvider.getDataPropertiesFile(declaringClass)));
        return PropertiesUtil.removeKeyPrefix((Properties)properties, (String)propertiesPrefix);
    }

    private static String getDataPropertiesFile(Class<?> declaringClass) {
        return "/" + declaringClass.getName().replaceAll("\\.", "/") + ".data.properties";
    }

    private static void checkProperties(Properties dataProperties) {
        if (!dataProperties.containsKey("strategy")) {
            throw new MissingPropertiesException(new String[]{"strategy"});
        }
        String strategy = dataProperties.getProperty("strategy");
        if (!GenericDataProvider.getStrategies().containsKey(strategy)) {
            throw new UnsupportedDataProviderStrategyException(strategy);
        }
    }

    private static Iterator<Object[]> getDataProvider(List<MethodParameter> parameters, Properties dataProperties) throws Exception {
        Class strategyClass = (Class)GenericDataProvider.getStrategies().get(dataProperties.getProperty("strategy"));
        MethodParametersAndPropertiesConstructorMatcher matcher = new MethodParametersAndPropertiesConstructorMatcher();
        Constructor constructor = Constructors.getMatchingConstructor((Class)strategyClass, (ConstructorMatcher)matcher);
        return (Iterator)constructor.newInstance(parameters, dataProperties);
    }

    private static List<MethodParameter> createMethodParameters(Method method) {
        ArrayList<MethodParameter> parameters = new ArrayList<MethodParameter>();
        Annotation[][] annotationsArray = method.getParameterAnnotations();
        Type[] parameterTypes = method.getGenericParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            List<Annotation> annotations = Arrays.asList(annotationsArray[i]);
            Type type = parameterTypes[i];
            String name = GenericDataProvider.resolveName(annotations, type);
            MethodParameter parameter = new MethodParameter(annotations, type, name);
            parameters.add(parameter);
        }
        return parameters;
    }

    private static String resolveName(List<Annotation> annotations, Type type) {
        Annotation annotation;
        if (Types.isSingleBeanType(type) || Types.isEnumType(type)) {
            return ((Class)type).getSimpleName();
        }
        if (Types.isListOfBeansType(type)) {
            return ((Class)((ParameterizedType)type).getActualTypeArguments()[0]).getSimpleName();
        }
        String name = null;
        Iterator<Annotation> i$ = annotations.iterator();
        while (i$.hasNext() && (name = Annotations.getName(annotation = i$.next())) == null) {
        }
        return name;
    }

    private static class DataProviderStrategiesMap
    extends HashMap<String, Class<? extends DataProviderStrategy>> {
        private static final long serialVersionUID = -1357728940375321662L;

        private DataProviderStrategiesMap() {
        }
    }
}

