package net.sf.testium.selenium.conditions;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.ExpectedCondition;

public class WrapperCondition<T> extends BaseCondition {

	private final ExpectedCondition<T> condition;
	
	public WrapperCondition( ExpectedCondition<T> condition ) {
		this.condition = condition;
	}

	public Boolean apply(WebDriver input) {
		T value = condition.apply(input);
		
        if (value != null && Boolean.class.equals(value.getClass())) {
            if (Boolean.TRUE.equals(value)) {
                return (Boolean) value;
            }
        } else if (value != null) {
            return true;
        }

		return false;
	}

	@Override
	public String toString() {
		return "Wrapped condition of " + condition;
	}
}
