package net.sf.testium.selenium.conditions;

import java.util.List;

import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;

public class ListSizeCondition implements ExpectedCondition<List<WebElement>> {

    private By by;
    private int expectedSize;

    public ListSizeCondition(By by, int originalSize) {
        this.by = by;
        this.expectedSize = originalSize;
    }
    
    public List<WebElement> apply(WebDriver webDriver) {
    	List<WebElement> elements = webDriver.findElements(by);
    	if ( elements.size() == expectedSize ) {
    		return elements;
    	}
    	return null;
    }
    
    @Override
	public String toString() {
		return "check that " + by.toString() + " is a list of size " + expectedSize;
	}
}
