package net.sf.testium.selenium.conditions;

import java.util.List;

import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

//TODO Can we use ExpectedConditions?
public class ElementPresentCondition extends BaseCondition {

    private By by;
    private boolean present;

    public ElementPresentCondition(By by, boolean present) {
        this.by = by;
        this.present = present;
    }
    
    public Boolean apply(WebDriver webDriver) {
    	List<WebElement> elements = webDriver.findElements(by);
    	if ( present ) {
    		return elements.size() > 0;
    	} // else
        return elements.size() == 0;
    }

	@Override
	public String toString() {
		return "check that " + by.toString() + (present ? " is present" : " is not present");
	}
}

