package net.sf.testium.selenium.conditions;

import org.openqa.selenium.WebDriver;

public class CombiCondition extends BaseCondition {

    public enum Combiner {
    	and,
    	or;
    }
    
    private BaseCondition cond1;
    private BaseCondition cond2;
    private Combiner combiner;

    public CombiCondition( BaseCondition cond1,
    					   BaseCondition cond2,
    					   Combiner combiner) {
        this.cond1 = cond1;
        this.cond2 = cond2;
        this.combiner = combiner;
    }

	public Boolean apply(WebDriver driver) {

		boolean result1 = cond1.apply(driver);
		boolean result2 = cond2.apply(driver);

    	if (combiner.equals(Combiner.and)) {
    		return (result1 && result2);
    	} else if (combiner.equals(Combiner.or)) {
    		return (result1 || result2);
    	}

		return false;
	}

    @Override
	public String toString() {
		return "check that " + cond1 + " " + combiner + " " + cond2;
	}
}
