package net.sf.testium.selenium;

import java.util.List;

import net.sf.testium.selenium.SmartWebElement;
import net.sf.testium.selenium.conditions.BaseCondition;
import net.sf.testium.selenium.conditions.CombiCondition;
import net.sf.testium.selenium.conditions.ElementPresentCondition;
import net.sf.testium.selenium.conditions.ListSizeCondition;

import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.WebDriverWait;


public class SmartWebDriverWait extends WebDriverWait {

	public final static long DEFAULT_TIMEOUT = 5; // in seconds
	public final static long DEFAULT_SLEEP_TIME = 500; // in milliseconds

	public static void WaitForElementPresent(WebDriver driver, SmartWebElement element) {
		new SmartWebDriverWait( driver ).until(element.getBy(), true);
	}

	public static void WaitForElementPresent(WebDriver driver, By by) {
		new SmartWebDriverWait( driver ).until(by, true);
	}

	public static void WaitForElementNotPresent(WebDriver driver, SmartWebElement element) {
		new SmartWebDriverWait( driver ).until(element.getBy(), false);
	}

	public static void WaitForElementNotPresent(WebDriver driver, By by) {
		new SmartWebDriverWait( driver ).until(by, false);
	}

	public static List<WebElement> WaitForListSize(WebDriver driver, SmartWebElement element, int expSize) {
		return new SmartWebDriverWait( driver ).until(element.getBy(), expSize);
	}

	public static List<WebElement> WaitForListSize(WebDriver driver, By by, int expSize) {
		return new SmartWebDriverWait( driver ).until(by, expSize);
	}

	/**
	 * @param driver
	 * @param cond1
	 * @param cond2
	 * @param combiner
	 * @return the return value of the first condition
	 */
	public static Boolean WaitForCombination( WebDriver driver,
											  BaseCondition cond1,
											  BaseCondition cond2,
											  CombiCondition.Combiner combiner ) {
		return new SmartWebDriverWait( driver ).until(cond1, cond2, combiner);
	}

	/**
	 * Constructor
	 * @param driver
	 */
	public SmartWebDriverWait( WebDriver driver ) {
		this(driver, DEFAULT_TIMEOUT, DEFAULT_SLEEP_TIME);
	}

	/**
	 * Constructor
	 * @param driver
	 * @param timeout
	 * @param sleepTime
	 */
	public SmartWebDriverWait(WebDriver driver, long timeout, long sleepTime) {
		super(driver, timeout, sleepTime);
	}

	public void until(By by, boolean present) {
		ElementPresentCondition condition = new ElementPresentCondition(by, present);
		this.withMessage( condition.toString() ).until( condition );
	}
	
	public List<WebElement> until( By by, int expectedSize ) {
		ListSizeCondition condition = new ListSizeCondition(by, expectedSize);
		return this.withMessage( condition.toString() ).until( condition );
	}
	
	public Boolean until( BaseCondition cond1,
						  BaseCondition cond2,
						  CombiCondition.Combiner combiner ) {
		CombiCondition condition = new CombiCondition( cond1, cond2, combiner );
		return this.withMessage( condition.toString() ).until( condition );
	}
}
