package net.sf.testium.selenium;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.List;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.Locatable;
import org.openqa.selenium.internal.WrapsElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.FindBys;
import org.openqa.selenium.support.pagefactory.DefaultFieldDecorator;
import org.openqa.selenium.support.pagefactory.internal.LocatingElementHandler;
import org.openqa.selenium.support.pagefactory.internal.LocatingElementListHandler;

public class SmartFieldDecorator extends DefaultFieldDecorator {

	private final WebDriver publisher;

	public SmartFieldDecorator(SmartElementLocatorFactory factory, WebDriver aWebDriver) {
		super( factory );
		publisher = aWebDriver;
	}

	@Override
	public Object decorate(ClassLoader loader, Field field) {
		if (!(WebElement.class.isAssignableFrom(field.getType()) || isDecoratableList(field))) {
			return null;
		}

		SmartElementLocator locator = ((SmartElementLocatorFactory) factory).createLocator(field);
		if (locator == null) {
			return null;
		}

		if (WebElement.class.isAssignableFrom(field.getType())) {
			return proxyForLocator(loader, locator);
		} else if (List.class.isAssignableFrom(field.getType())) {
			return proxyForListLocator(loader, locator);
		} else {
			return null;
		}
	}

	private boolean isDecoratableList(Field field) {
		if (!List.class.isAssignableFrom(field.getType())) {
			return false;
		}

		// Type erasure in Java isn't complete. Attempt to discover the generic
		// type of the list.
		Type genericType = field.getGenericType();
		if (!(genericType instanceof ParameterizedType)) {
			return false;
		}

		Type listType = ((ParameterizedType) genericType)
				.getActualTypeArguments()[0];

		if (!WebElement.class.equals(listType)) {
			return false;
		}

		if (field.getAnnotation(FindBy.class) == null
				&& field.getAnnotation(FindBys.class) == null) {
			return false;
		}

		return true;
	}

	protected WebElement proxyForLocator(ClassLoader loader,
			SmartElementLocator locator) {
		InvocationHandler handler = new LocatingElementHandler(locator);

		// TODO probably SimplePageElement also has to implement WrapsElement and Locatable 
		SmartWebElement proxy = (SmartWebElement) Proxy.newProxyInstance(loader, new Class[] {
				SmartWebElement.class, WrapsElement.class, Locatable.class },
				handler);

		if (this.publisher instanceof FieldPublisher )
		{

			String testiumName = locator.getTestiumName();
			if ( testiumName != "" ) {	
				((FieldPublisher) publisher).addElement(testiumName, proxy);
			}
		}

		return proxy;
	}
	
	protected List<WebElement> proxyForListLocator(ClassLoader loader, SmartElementLocator locator)	{
		InvocationHandler handler = new LocatingElementListHandler(locator);

		SmartWebElementList proxy = (SmartWebElementList) Proxy.newProxyInstance(loader, new Class[] {
				List.class, SmartWebElementList.class },
				handler);
	
		if (this.publisher instanceof FieldPublisher )
		{

			String testiumName = locator.getTestiumName();
			if ( testiumName != "" ) {	
				((FieldPublisher) publisher).addElement(testiumName, proxy);
			}
		}

		return proxy;
	}
}
