package net.sf.testium.selenium;

public interface PageElement {
	
	/**
	 * Is the element currently present or not? This will generally return true for everything 
	 * that can be found in the DOM.
	 * 
	 * @return True if the element is present, false otherwise.
	 */
	public boolean isPresent();
	
	/**
	 * Is the element currently enabled or not? This will generally return true for everything but
	 * disabled input elements.
	 * 
	 * @return True if the element is enabled, false otherwise.
	 * @throws org.openqa.selenium.StaleElementReferenceException
	 * @see org.openqa.selenium.WebElement#isEnabled()
	 */
	public boolean isEnabled();

	/**
	 * Is this element displayed or not? This method avoids the problem of having to parse an
	 * element's "style" attribute.
	 * 
	 * @return Whether or not the element is displayed
	 * @throws org.openqa.selenium.StaleElementReferenceException
	 * @see org.openqa.selenium.WebElement#isDisplayed()
	 */
	public boolean isDisplayed();
	
	/**
	 * @return the timeout that can be used for this page to load.
	 */
	public int getTimeout();
}
