package net.sf.testium.selenium;

import java.util.Map;

import org.openqa.selenium.WebElement;

public interface ExpectedResultTable extends Map<String, PageElement> {

	/**
	 * Adds an action and PageElement to the map
	 * @param action - the Selenium action
	 * @param PageElement - the element that must be visible after the action 
	 */
	public void addExpectedResult( String action, WebElement PageElement );
	
	/**
	 * @param action - the Selenium action
	 * @return the element that must be visible after the action 
	 */
	public PageElement getElement( String action );

}
