package net.sf.testium.selenium;

import org.openqa.selenium.support.PageFactory;

abstract public class ComplexPageElement implements PageElement {

	public static final int DEFAULT_TIMEOUT = 5; //seconds

	private int myTimeout = DEFAULT_TIMEOUT;

	public ComplexPageElement( ) {
		this( DEFAULT_TIMEOUT );
	}

	public ComplexPageElement( int aTimeout ) {
		myTimeout = aTimeout;
	}

	abstract public boolean isPresent();

	abstract public boolean isEnabled();

	abstract public boolean isDisplayed();

	public int getTimeout() {
		return myTimeout;
	}
	
	public void setTimeout( int aTimeout ) {
		myTimeout = aTimeout;
	}

	/**
	 * 
	 */
	protected void initElements( WebDriverInterface iface ) {
	    final WebDriverInterface interfaceRef = iface;
	    final SmartElementLocatorFactory factoryRef = new SmartElementLocatorFactory(interfaceRef);
	    PageFactory.initElements(new SmartFieldDecorator(factoryRef, iface.getDriver()), this);
	}

}
