/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testium.executor.webdriver.commands;

import java.io.File;
import java.util.ArrayList;
import net.sf.testium.configuration.SeleniumInterfaceConfiguration;
import net.sf.testium.executor.general.SpecifiedParameter;
import net.sf.testium.executor.webdriver.WebInterface;
import net.sf.testium.executor.webdriver.commands.GenericSeleniumCommandExecutor;
import org.testtoolinterfaces.testresult.TestResult;
import org.testtoolinterfaces.testresult.TestStepCommandResult;
import org.testtoolinterfaces.testresult.TestStepResult;
import org.testtoolinterfaces.testresult.impl.TestStepCommandResultImpl;
import org.testtoolinterfaces.testsuite.ParameterArrayList;
import org.testtoolinterfaces.testsuite.TestStepCommand;
import org.testtoolinterfaces.testsuite.TestSuiteException;
import org.testtoolinterfaces.utils.RunTimeData;

public class SavePageSource
extends GenericSeleniumCommandExecutor {
    private static final String COMMAND = "savePageSource";
    public static final SpecifiedParameter PARSPEC_FILE_NAME = new SpecifiedParameter("filename", String.class, "Name of the file to use when saving the page-source", true, true, true, false).setDefaultValue((Object)"");

    public SavePageSource(WebInterface aWebInterface) {
        super(COMMAND, "Saves the page source to a specified filename", aWebInterface, new ArrayList<SpecifiedParameter>());
        this.getParameterSpecs().remove(GenericSeleniumCommandExecutor.PARSPEC_SAVE_PAGE_SOURCE);
        this.setSaveScreenshot(SeleniumInterfaceConfiguration.SAVE_SOURCE.NEVER);
        this.addParamSpec(PARSPEC_FILE_NAME);
    }

    public TestStepResult execute(TestStepCommand aStep, RunTimeData aVariables, File aLogDir) throws TestSuiteException {
        ParameterArrayList parameters = aStep.getParameters();
        this.verifyParameters(parameters);
        TestStepCommandResultImpl result = new TestStepCommandResultImpl(aStep);
        String fileName = "";
        try {
            fileName = (String)this.obtainOptionalValue(aVariables, parameters, PARSPEC_FILE_NAME);
        }
        catch (Exception e) {
            result.setResult(TestResult.VERDICT.ERROR);
            result.addComment(e.getMessage());
        }
        if (this.savePageSource(aLogDir, fileName, (TestStepResult)result)) {
            result.setResult(TestResult.VERDICT.PASSED);
        } else {
            result.setResult(TestResult.VERDICT.FAILED);
        }
        return result;
    }

    protected void doExecute(RunTimeData aVariables, ParameterArrayList parameters, TestStepCommandResult result) throws Exception {
        throw new Error("Method should not have been called");
    }
}

