/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testium.executor.webdriver.commands;

import java.util.ArrayList;
import net.sf.testium.executor.general.SpecifiedParameter;
import net.sf.testium.executor.webdriver.WebInterface;
import net.sf.testium.executor.webdriver.commands.GenericSeleniumCommandExecutor;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.testtoolinterfaces.testresult.TestStepCommandResult;
import org.testtoolinterfaces.testsuite.ParameterArrayList;
import org.testtoolinterfaces.utils.RunTimeData;

public class CentralizeItem
extends GenericSeleniumCommandExecutor {
    private static final String COMMAND = "centralizeItem";
    private static final String PAR_ELEMENT = "element";
    public static final SpecifiedParameter PARSPEC_ELEMENT = new SpecifiedParameter("element", WebElement.class, false, false, true, false);

    public CentralizeItem(WebInterface aWebInterface) {
        super(COMMAND, aWebInterface, new ArrayList<SpecifiedParameter>());
        this.addParamSpec(PARSPEC_ELEMENT);
    }

    protected void doExecute(RunTimeData aVariables, ParameterArrayList parameters, TestStepCommandResult result) throws Exception {
        WebElement element = this.obtainElement(aVariables, parameters, PARSPEC_ELEMENT);
        String elementName = parameters.get(PAR_ELEMENT).getName();
        result.setDisplayName(this.toString() + " " + elementName);
        this.centralizeElement(element);
    }

    private int getLocationY(WebElement anElement) {
        return anElement.getLocation().getY();
    }

    private int getWindowSize(RemoteWebDriver aDriver) {
        return aDriver.manage().window().getSize().height;
    }

    protected void centralizeElement(WebElement anElement) {
        if (this.getDriver() instanceof RemoteWebDriver) {
            RemoteWebDriver driver = (RemoteWebDriver)this.getDriver();
            int scrollToY = this.getLocationY(anElement) - this.getWindowSize(driver) / 2;
            driver.executeScript("scrollTo(0," + scrollToY + ");", new Object[0]);
        }
    }
}

