/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testium.selenium;

import java.util.ArrayList;
import java.util.List;
import net.sf.testium.selenium.SimpleElementList;
import net.sf.testium.selenium.SmartWebElement;
import net.sf.testium.selenium.WebDriverInterface;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.ElementNotVisibleException;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.Point;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.internal.Coordinates;
import org.openqa.selenium.internal.FindsByClassName;
import org.openqa.selenium.internal.FindsByCssSelector;
import org.openqa.selenium.internal.FindsById;
import org.openqa.selenium.internal.FindsByLinkText;
import org.openqa.selenium.internal.FindsByName;
import org.openqa.selenium.internal.FindsByTagName;
import org.openqa.selenium.internal.FindsByXPath;
import org.openqa.selenium.internal.Locatable;
import org.openqa.selenium.internal.WrapsDriver;
import org.openqa.selenium.internal.WrapsElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplePageElement
implements SmartWebElement,
WrapsElement,
FindsByLinkText,
FindsById,
FindsByName,
FindsByTagName,
FindsByClassName,
FindsByCssSelector,
FindsByXPath,
WrapsDriver,
Locatable {
    private final By myBy;
    private final WebDriverInterface myInterface;
    private WebElement myElement;
    private final WebElement myBaseElement;
    private WebElement myFrame;

    public SimplePageElement(By by, WebDriverInterface iface) {
        this(by, iface, null, null);
    }

    public SimplePageElement(By by, WebDriverInterface iface, WebElement element) {
        this(by, iface, element, null);
    }

    public SimplePageElement(By by, WebDriverInterface iface, WebElement element, WebElement baseElement) {
        this.myBy = by;
        this.myInterface = iface;
        this.myElement = element;
        this.myBaseElement = baseElement;
        if (element instanceof SmartWebElement) {
            SmartWebElement elm = (SmartWebElement)element;
            this.myElement = elm.getElement();
        }
        this.myFrame = null;
    }

    @Override
    public By getBy() {
        return this.myBy;
    }

    public WebDriverInterface getInterface() {
        return this.myInterface;
    }

    public void click() {
        this.getElement().click();
    }

    public void submit() {
        this.getElement().submit();
    }

    public void sendKeys(CharSequence ... keysToSend) {
        this.getElement().sendKeys(keysToSend);
    }

    public void clear() {
        this.getElement().clear();
    }

    public String getTagName() {
        return this.getElement().getTagName();
    }

    public String getAttribute(String name) {
        return this.getElement().getAttribute(name);
    }

    public boolean isSelected() {
        return this.getElement().isSelected();
    }

    public boolean isEnabled() {
        return this.getElement().isEnabled();
    }

    public String getText() {
        return this.getElement().getText();
    }

    public List<WebElement> findElements(By by) {
        List elements = this.getElement().findElements(by);
        return new SimpleElementList(by, this.getInterface(), elements, this);
    }

    public SmartWebElement findElement(By by) {
        WebElement element = this.getElement().findElement(by);
        return new SimplePageElement(by, this.getInterface(), element, this);
    }

    public boolean isDisplayed() {
        return this.getElement().isDisplayed();
    }

    public Point getLocation() {
        return this.getElement().getLocation();
    }

    public Dimension getSize() {
        return this.getElement().getSize();
    }

    public String getCssValue(String propertyName) {
        return this.getElement().getCssValue(propertyName);
    }

    public Coordinates getCoordinates() {
        WebElement element = this.getElement();
        if (element instanceof Locatable) {
            return ((Locatable)element).getCoordinates();
        }
        return null;
    }

    public WebDriver getWrappedDriver() {
        return this.myInterface.getDriver();
    }

    public WebElement findElementByXPath(String paramString) {
        WebElement element = this.getElement();
        WebElement foundElement = null;
        if (element instanceof FindsByXPath) {
            foundElement = ((FindsByXPath)element).findElementByXPath(paramString);
        }
        return new SimplePageElement(By.xpath((String)paramString), this.getInterface(), foundElement, this);
    }

    public List<WebElement> findElementsByXPath(String paramString) {
        WebElement element = this.getElement();
        List foundElements = new ArrayList();
        if (element instanceof FindsByXPath) {
            foundElements = ((FindsByXPath)element).findElementsByXPath(paramString);
        }
        return new SimpleElementList(By.xpath((String)paramString), this.getInterface(), foundElements, this);
    }

    public WebElement findElementByCssSelector(String paramString) {
        WebElement element = this.getElement();
        WebElement foundElement = null;
        if (element instanceof FindsByCssSelector) {
            foundElement = ((FindsByCssSelector)element).findElementByCssSelector(paramString);
        }
        return new SimplePageElement(By.cssSelector((String)paramString), this.getInterface(), foundElement, this);
    }

    public List<WebElement> findElementsByCssSelector(String paramString) {
        WebElement element = this.getElement();
        List foundElements = new ArrayList();
        if (element instanceof FindsByCssSelector) {
            foundElements = ((FindsByCssSelector)element).findElementsByCssSelector(paramString);
        }
        return new SimpleElementList(By.cssSelector((String)paramString), this.getInterface(), foundElements, this);
    }

    public WebElement findElementByClassName(String paramString) {
        WebElement element = this.getElement();
        WebElement foundElement = null;
        if (element instanceof FindsByClassName) {
            foundElement = ((FindsByClassName)element).findElementByClassName(paramString);
        }
        return new SimplePageElement(By.className((String)paramString), this.getInterface(), foundElement, this);
    }

    public List<WebElement> findElementsByClassName(String paramString) {
        WebElement element = this.getElement();
        List foundElements = new ArrayList();
        if (element instanceof FindsByClassName) {
            foundElements = ((FindsByClassName)element).findElementsByClassName(paramString);
        }
        return new SimpleElementList(By.className((String)paramString), this.getInterface(), foundElements, this);
    }

    public WebElement findElementByTagName(String paramString) {
        WebElement element = this.getElement();
        WebElement foundElement = null;
        if (element instanceof FindsByTagName) {
            foundElement = ((FindsByTagName)element).findElementByTagName(paramString);
        }
        return new SimplePageElement(By.tagName((String)paramString), this.getInterface(), foundElement, this);
    }

    public List<WebElement> findElementsByTagName(String paramString) {
        WebElement element = this.getElement();
        List foundElements = new ArrayList();
        if (element instanceof FindsByTagName) {
            foundElements = ((FindsByTagName)element).findElementsByTagName(paramString);
        }
        return new SimpleElementList(By.tagName((String)paramString), this.getInterface(), foundElements, this);
    }

    public WebElement findElementByName(String paramString) {
        WebElement element = this.getElement();
        WebElement foundElement = null;
        if (element instanceof FindsByName) {
            foundElement = ((FindsByName)element).findElementByName(paramString);
        }
        return new SimplePageElement(By.name((String)paramString), this.getInterface(), foundElement, this);
    }

    public List<WebElement> findElementsByName(String paramString) {
        WebElement element = this.getElement();
        List foundElements = new ArrayList();
        if (element instanceof FindsByName) {
            foundElements = ((FindsByName)element).findElementsByName(paramString);
        }
        return new SimpleElementList(By.name((String)paramString), this.getInterface(), foundElements, this);
    }

    public WebElement findElementById(String paramString) {
        WebElement element = this.getElement();
        WebElement foundElement = null;
        if (element instanceof FindsById) {
            foundElement = ((FindsById)element).findElementById(paramString);
        }
        return new SimplePageElement(By.id((String)paramString), this.getInterface(), foundElement, this);
    }

    public List<WebElement> findElementsById(String paramString) {
        WebElement element = this.getElement();
        List foundElements = new ArrayList();
        if (element instanceof FindsById) {
            foundElements = ((FindsById)element).findElementsById(paramString);
        }
        return new SimpleElementList(By.id((String)paramString), this.getInterface(), foundElements, this);
    }

    public WebElement findElementByLinkText(String paramString) {
        WebElement element = this.getElement();
        WebElement foundElement = null;
        if (element instanceof FindsByLinkText) {
            foundElement = ((FindsByLinkText)element).findElementByLinkText(paramString);
        }
        return new SimplePageElement(By.linkText((String)paramString), this.getInterface(), foundElement, this);
    }

    public List<WebElement> findElementsByLinkText(String paramString) {
        WebElement element = this.getElement();
        List foundElements = new ArrayList();
        if (element instanceof FindsByLinkText) {
            foundElements = ((FindsByLinkText)element).findElementsByLinkText(paramString);
        }
        return new SimpleElementList(By.linkText((String)paramString), this.getInterface(), foundElements, this);
    }

    public WebElement findElementByPartialLinkText(String paramString) {
        WebElement element = this.getElement();
        WebElement foundElement = null;
        if (element instanceof FindsByLinkText) {
            foundElement = ((FindsByLinkText)element).findElementByPartialLinkText(paramString);
        }
        return new SimplePageElement(By.partialLinkText((String)paramString), this.getInterface(), foundElement, this);
    }

    public List<WebElement> findElementsByPartialLinkText(String paramString) {
        WebElement element = this.getElement();
        List foundElements = new ArrayList();
        if (element instanceof FindsByLinkText) {
            foundElements = ((FindsByLinkText)element).findElementsByPartialLinkText(paramString);
        }
        return new SimpleElementList(By.partialLinkText((String)paramString), this.getInterface(), foundElements, this);
    }

    @Override
    public WebElement getElement() {
        if (this.myElement == null) {
            this.refreshElement();
        } else {
            try {
                this.myElement.isDisplayed();
            }
            catch (NotFoundException ignored) {
                this.refreshElement();
            }
            catch (ElementNotVisibleException ignored) {
                this.refreshElement();
            }
            catch (StaleElementReferenceException ignored) {
                this.refreshElement();
            }
        }
        return this.myElement;
    }

    private void refreshElement() throws Error {
        WebDriver driver = this.getDriver();
        if (this.myFrame == null) {
            driver.switchTo().defaultContent();
        } else {
            driver.switchTo().frame(this.myFrame);
        }
        this.myElement = this.myBaseElement != null ? this.myBaseElement.findElement(this.myBy) : driver.findElement(this.myBy);
    }

    private WebDriver getDriver() throws Error {
        WebDriver driver = this.getInterface().getDriver();
        if (driver == null) {
            throw new Error("Element requested, but driver is not yet created: '" + this.myBy + "'. Make sure this interface (" + this.getInterface().toString() + ") opens a browser first.");
        }
        return driver;
    }

    public void setFrame(WebElement frame) {
        this.myFrame = frame;
    }

    public WebElement getWrappedElement() {
        return this.getElement();
    }
}

