/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testium.executor.webdriver.commands;

import java.util.ArrayList;
import net.sf.testium.executor.general.CheckString;
import net.sf.testium.executor.general.SpecifiedParameter;
import net.sf.testium.executor.webdriver.WebInterface;
import net.sf.testium.executor.webdriver.commands.GenericSeleniumCommandExecutor;
import org.openqa.selenium.WebDriver;
import org.testtoolinterfaces.testresult.TestStepCommandResult;
import org.testtoolinterfaces.testsuite.ParameterArrayList;
import org.testtoolinterfaces.utils.RunTimeData;

public class CheckCurrentUrl
extends GenericSeleniumCommandExecutor {
    private static final String COMMAND = "checkCurrentUrl";
    private static final String PAR_URL = "url";
    public static final SpecifiedParameter PARSPEC_URL = new SpecifiedParameter("url", String.class, false, true, true, false);

    public CheckCurrentUrl(WebInterface aWebInterface) {
        super(COMMAND, aWebInterface, new ArrayList<SpecifiedParameter>());
        this.addParamSpec(PARSPEC_URL);
        this.addParamSpec(CheckString.PARSPEC_MATCH);
    }

    protected void doExecute(RunTimeData aVariables, ParameterArrayList parameters, TestStepCommandResult result) throws Exception {
        WebDriver webDriver = this.getDriver();
        String expectedUrl = (String)this.obtainValue(aVariables, parameters, PARSPEC_URL);
        String matchStr = (String)this.obtainOptionalValue(aVariables, parameters, CheckString.PARSPEC_MATCH);
        CheckString.MATCH match = CheckString.MATCH.enumOf((String)matchStr);
        String currentUrl = webDriver.getCurrentUrl();
        CheckString.checkString((String)currentUrl, (String)expectedUrl, (CheckString.MATCH)match, (boolean)false, (String)"Actual URL");
    }
}

