/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testium.executor.webdriver.commands;

import java.util.ArrayList;
import net.sf.testium.executor.general.SpecifiedParameter;
import net.sf.testium.executor.webdriver.WebInterface;
import net.sf.testium.executor.webdriver.commands.GenericSeleniumCommandExecutor;
import org.testtoolinterfaces.testresult.TestStepCommandResult;
import org.testtoolinterfaces.testsuite.ParameterArrayList;
import org.testtoolinterfaces.testsuite.TestSuiteException;
import org.testtoolinterfaces.utils.RunTimeData;

public class SwitchTo
extends GenericSeleniumCommandExecutor {
    private static final String COMMAND = "switchTo";
    private static final String PAR_WINDOW = "window";
    private static final String PAR_FRAME = "frame";
    private static final String PAR_ALERT = "alert";
    private static final SpecifiedParameter PARSPEC_WINDOW = new SpecifiedParameter("window", String.class, true, true, true, false).setDefaultValue((Object)"");
    private static final SpecifiedParameter PARSPEC_FRAME = new SpecifiedParameter("frame", String.class, true, true, true, false).setDefaultValue((Object)"");
    private static final SpecifiedParameter PARSPEC_ALERT = new SpecifiedParameter("alert", String.class, true, true, true, false).setDefaultValue((Object)"");

    public SwitchTo(WebInterface aWebInterface) {
        super(COMMAND, aWebInterface, new ArrayList<SpecifiedParameter>());
        this.addParamSpec(PARSPEC_WINDOW);
        this.addParamSpec(PARSPEC_FRAME);
        this.addParamSpec(PARSPEC_ALERT);
    }

    protected void doExecute(RunTimeData aVariables, ParameterArrayList parameters, TestStepCommandResult result) throws Exception {
        String window = (String)this.obtainValue(aVariables, parameters, PARSPEC_WINDOW);
        String frame = (String)this.obtainValue(aVariables, parameters, PARSPEC_FRAME);
        String alert = (String)this.obtainValue(aVariables, parameters, PARSPEC_ALERT);
        if (!window.isEmpty()) {
            this.getDriver().switchTo().window(window);
        } else if (!frame.isEmpty()) {
            this.getDriver().switchTo().frame(frame);
        } else if (!alert.isEmpty()) {
            this.getDriver().switchTo().alert();
        } else {
            throw new TestSuiteException("One of parameters window, frame, and alert must be set.", this.toString());
        }
    }
}

