/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testium.plugins;

import java.io.File;
import java.net.MalformedURLException;
import net.sf.testium.Testium;
import net.sf.testium.configuration.ConfigurationException;
import net.sf.testium.configuration.CustomStepDefinitionsXmlHandler;
import net.sf.testium.configuration.PersonalSeleniumConfigurationXmlHandler;
import net.sf.testium.configuration.SeleniumConfiguration;
import net.sf.testium.configuration.SeleniumConfigurationXmlHandler;
import net.sf.testium.configuration.SeleniumInterfaceConfiguration;
import net.sf.testium.configuration.SeleniumInterfaceXmlHandler;
import net.sf.testium.executor.CustomInterface;
import net.sf.testium.executor.DefaultInterface;
import net.sf.testium.executor.SupportedInterfaceList;
import net.sf.testium.executor.TestStepCommandExecutor;
import net.sf.testium.executor.TestStepMetaExecutor;
import net.sf.testium.executor.webdriver.WebInterface;
import net.sf.testium.executor.webdriver.commands.CheckListSize_modified;
import net.sf.testium.executor.webdriver.commands.GetListItem_modified;
import net.sf.testium.executor.webdriver.commands.GetListSize_modified;
import net.sf.testium.plugins.Plugin;
import net.sf.testium.plugins.PluginClassLoader;
import net.sf.testium.plugins.PluginCollection;
import net.sf.testium.systemundertest.SutInterface;
import org.testtoolinterfaces.testsuite.TestInterface;
import org.testtoolinterfaces.testsuite.TestInterfaceList;
import org.testtoolinterfaces.utils.RunTimeData;
import org.testtoolinterfaces.utils.TTIException;
import org.testtoolinterfaces.utils.Trace;
import org.testtoolinterfaces.utils.XmlHandler;
import org.xml.sax.XMLReader;

public class SeleniumPlugin
implements Plugin {
    public static final String BASEURL = "BaseUrl";

    public void loadPlugIn(PluginCollection aPluginCollection, RunTimeData anRtData) throws ConfigurationException {
        SupportedInterfaceList interfaceList = aPluginCollection.getInterfaces();
        TestStepMetaExecutor testStepMetaExecutor = aPluginCollection.getTestStepExecutor();
        SeleniumConfiguration config = this.readConfigFile(anRtData);
        File seleniumLibsDir = config.getSeleniumLibsDir();
        try {
            PluginClassLoader.addDirToClassLoader((File)seleniumLibsDir);
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException((Throwable)e);
        }
        DefaultInterface defInterface = (DefaultInterface)interfaceList.getInterface("Default");
        defInterface.add((TestStepCommandExecutor)new CheckListSize_modified((SutInterface)defInterface));
        defInterface.add((TestStepCommandExecutor)new GetListItem_modified((SutInterface)defInterface));
        defInterface.add((TestStepCommandExecutor)new GetListSize_modified(defInterface));
        this.createInterfaces(anRtData, interfaceList, testStepMetaExecutor, config);
    }

    private void createInterfaces(RunTimeData anRtData, SupportedInterfaceList anInterfaceList, TestStepMetaExecutor aTestStepMetaExecutor, SeleniumConfiguration aConfig) throws ConfigurationException {
        for (String interfaceName : aConfig.getInterfaceNames()) {
            this.createInterface(anRtData, anInterfaceList, aTestStepMetaExecutor, aConfig, interfaceName);
        }
    }

    private void createInterface(RunTimeData anRtData, SupportedInterfaceList anInterfaceList, TestStepMetaExecutor aTestStepMetaExecutor, SeleniumConfiguration aConfig, String anInterfaceName) throws ConfigurationException {
        String sysPropBaseUrl;
        File configDir = (File)anRtData.getValue(Testium.CONFIGDIR);
        File interfaceConfigurationFile = new File(configDir, anInterfaceName + ".xml");
        SeleniumInterfaceConfiguration globalIfConfig = this.readGloaInterfaceConfiguration(interfaceConfigurationFile, anInterfaceName, aConfig);
        File userConfigDir = (File)anRtData.getValue(Testium.USERCONFIGDIR);
        File personalInterfaceConfigurationFile = new File(userConfigDir, anInterfaceName + ".xml");
        SeleniumInterfaceConfiguration ifConfig = globalIfConfig;
        if (personalInterfaceConfigurationFile.canRead()) {
            ifConfig = this.readPersonalInterfaceConfiguration(personalInterfaceConfigurationFile, anInterfaceName, globalIfConfig);
        }
        if ((sysPropBaseUrl = System.getProperty(anInterfaceName + "." + BASEURL)) != null) {
            ifConfig.setBaseUrl(sysPropBaseUrl);
        }
        WebInterface iface = new WebInterface(anInterfaceName, anRtData, ifConfig);
        anInterfaceList.add((TestInterface)iface);
        this.createCustomKeywords(anRtData, anInterfaceList, aTestStepMetaExecutor, ifConfig, iface);
    }

    private void createCustomKeywords(RunTimeData anRtData, SupportedInterfaceList interfaceList, TestStepMetaExecutor testStepMetaExecutor, SeleniumInterfaceConfiguration ifConfig, WebInterface iface) throws ConfigurationException {
        for (String keywordsDefLink : ifConfig.getCustomKeywordLinks()) {
            String fileName = anRtData.substituteVars(keywordsDefLink);
            CustomStepDefinitionsXmlHandler.loadElementDefinitions((File)new File(fileName), (RunTimeData)anRtData, (CustomInterface)iface, (TestInterfaceList)interfaceList, (TestStepMetaExecutor)testStepMetaExecutor);
        }
    }

    private SeleniumInterfaceConfiguration readGloaInterfaceConfiguration(File interfaceDefinitionsFile, String ifName, SeleniumConfiguration selConfig) throws ConfigurationException {
        Trace.println((Trace.LEVEL)Trace.UTIL, (String)("readInterfaceConfiguration( " + interfaceDefinitionsFile.getName() + ", " + ifName + " )"), (boolean)true);
        SeleniumInterfaceXmlHandler handler = null;
        try {
            XMLReader reader = XmlHandler.getNewXmlReader();
            handler = new SeleniumInterfaceXmlHandler(reader, selConfig);
            handler.parse(reader, interfaceDefinitionsFile);
        }
        catch (TTIException e) {
            throw new ConfigurationException((Throwable)e);
        }
        SeleniumInterfaceConfiguration ifConfiguration = handler.getConfiguration(ifName);
        handler.reset();
        return ifConfiguration;
    }

    private SeleniumInterfaceConfiguration readPersonalInterfaceConfiguration(File personalInterfaceConfigurationFile, String ifName, SeleniumInterfaceConfiguration globalIfConfig) throws ConfigurationException {
        Trace.println((Trace.LEVEL)Trace.UTIL, (String)("readInterfaceConfiguration( " + personalInterfaceConfigurationFile.getName() + ", " + ifName + " )"), (boolean)true);
        SeleniumInterfaceXmlHandler handler = null;
        try {
            XMLReader reader = XmlHandler.getNewXmlReader();
            handler = new SeleniumInterfaceXmlHandler(reader, globalIfConfig);
            handler.parse(reader, personalInterfaceConfigurationFile);
        }
        catch (TTIException e) {
            throw new ConfigurationException((Throwable)e);
        }
        SeleniumInterfaceConfiguration ifConfiguration = handler.getConfiguration(ifName);
        handler.reset();
        return ifConfiguration;
    }

    public final SeleniumConfiguration readConfigFile(RunTimeData anRtData) throws ConfigurationException {
        Trace.println((Trace.LEVEL)Trace.UTIL);
        File configDir = (File)anRtData.getValue(Testium.CONFIGDIR);
        File configFile = new File(configDir, "selenium.xml");
        SeleniumConfiguration globalConfig = this.readConfigFile(anRtData, configFile);
        File userConfigDir = (File)anRtData.getValue(Testium.USERCONFIGDIR);
        File userConfigFile = new File(userConfigDir, "selenium.xml");
        if (userConfigFile.exists()) {
            return this.readPersonalConfigFile(globalConfig, userConfigFile);
        }
        return globalConfig;
    }

    public final SeleniumConfiguration readConfigFile(RunTimeData anRtData, File aConfigFile) throws ConfigurationException {
        SeleniumConfigurationXmlHandler myHandler;
        Trace.println((Trace.LEVEL)Trace.UTIL, (String)("readConfigFile( " + aConfigFile.getName() + " )"), (boolean)true);
        try {
            XMLReader reader = XmlHandler.getNewXmlReader();
            myHandler = new SeleniumConfigurationXmlHandler(reader, anRtData);
            myHandler.parse(reader, aConfigFile);
        }
        catch (TTIException e) {
            Trace.print((Trace.LEVEL)Trace.UTIL, (Throwable)e);
            throw new ConfigurationException((Throwable)e);
        }
        SeleniumConfiguration configuration = myHandler.getConfiguration();
        return configuration;
    }

    public final SeleniumConfiguration readPersonalConfigFile(SeleniumConfiguration globalConfig, File aConfigFile) throws ConfigurationException {
        PersonalSeleniumConfigurationXmlHandler myHandler;
        Trace.println((Trace.LEVEL)Trace.UTIL, (String)("readConfigFile( " + aConfigFile.getName() + " )"), (boolean)true);
        try {
            XMLReader reader = XmlHandler.getNewXmlReader();
            myHandler = new PersonalSeleniumConfigurationXmlHandler(reader, globalConfig);
            myHandler.parse(reader, aConfigFile);
        }
        catch (TTIException e) {
            Trace.print((Trace.LEVEL)Trace.UTIL, (Throwable)e);
            throw new ConfigurationException((Throwable)e);
        }
        SeleniumConfiguration configuration = myHandler.getConfiguration();
        return configuration;
    }

    public static void loadElementDefinitions(File aFile, RunTimeData anRtData, CustomInterface anInterface, TestInterfaceList anInterfaceList, TestStepMetaExecutor aTestStepMetaExecutor) throws ConfigurationException {
        Trace.println((Trace.LEVEL)Trace.UTIL, (String)("loadElementDefinitions( " + aFile.getName() + " )"), (boolean)true);
        CustomStepDefinitionsXmlHandler handler = null;
        try {
            XMLReader reader = XmlHandler.getNewXmlReader();
            handler = new CustomStepDefinitionsXmlHandler(reader, anRtData, anInterface, anInterfaceList, aTestStepMetaExecutor);
            handler.parse(reader, aFile);
        }
        catch (TTIException e) {
            Trace.print((Trace.LEVEL)Trace.UTIL, (Throwable)e);
            throw new ConfigurationException((Throwable)e);
        }
    }
}

