/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testium.executor.webdriver.commands;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import net.sf.testium.configuration.SeleniumConfiguration;
import net.sf.testium.configuration.SeleniumInterfaceConfiguration;
import net.sf.testium.executor.general.GenericCommandExecutor;
import net.sf.testium.executor.general.SpecifiedParameter;
import net.sf.testium.executor.webdriver.WebInterface;
import net.sf.testium.systemundertest.SutInterface;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.Augmenter;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.UnreachableBrowserException;
import org.testtoolinterfaces.testresult.TestResult;
import org.testtoolinterfaces.testresult.TestStepCommandResult;
import org.testtoolinterfaces.testresult.TestStepResult;
import org.testtoolinterfaces.testresult.impl.TestStepCommandResultImpl;
import org.testtoolinterfaces.testsuite.Parameter;
import org.testtoolinterfaces.testsuite.ParameterArrayList;
import org.testtoolinterfaces.testsuite.ParameterImpl;
import org.testtoolinterfaces.testsuite.TestStepCommand;
import org.testtoolinterfaces.testsuite.TestSuiteException;
import org.testtoolinterfaces.utils.RunTimeData;
import org.testtoolinterfaces.utils.Trace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericSeleniumCommandExecutor
extends GenericCommandExecutor {
    private SeleniumInterfaceConfiguration.SAVE_SOURCE mySavePageSource;
    private SeleniumInterfaceConfiguration.SAVE_SOURCE mySaveScreenshot;
    public static final SpecifiedParameter PARSPEC_SAVE_PAGE_SOURCE = new SpecifiedParameter("SavePageSource", String.class, true, true, true, true).setDefaultValue((Object)"");
    public static final SpecifiedParameter PARSPEC_SAVE_SCREEN_SHOT = new SpecifiedParameter("SaveScreenshot", String.class, true, true, true, true).setDefaultValue((Object)"");

    protected abstract void doExecute(RunTimeData var1, ParameterArrayList var2, TestStepCommandResult var3) throws Exception;

    public GenericSeleniumCommandExecutor(String command, WebInterface aWebInterface, ArrayList<SpecifiedParameter> parameterSpecs) {
        super(command, (SutInterface)aWebInterface, parameterSpecs);
        this.mySavePageSource = aWebInterface.getConfig().getSavePageSource();
        this.mySaveScreenshot = aWebInterface.getConfig().getSaveScreenShot();
        this.addParamSpec(PARSPEC_SAVE_PAGE_SOURCE);
        this.addParamSpec(PARSPEC_SAVE_SCREEN_SHOT);
    }

    protected WebInterface getInterface() {
        return (WebInterface)super.getInterface();
    }

    protected WebDriver getDriver() {
        return this.getInterface().getDriver();
    }

    protected WebDriver getDriver(SeleniumConfiguration.BROWSER_TYPE aBrowserType) {
        WebDriver webDriver = this.getInterface().getDriver(aBrowserType);
        return webDriver;
    }

    @Deprecated
    protected WebDriver getDriverAndSetResult(TestStepResult aTestStepResult, SeleniumConfiguration.BROWSER_TYPE aBrowserType) {
        WebDriver webDriver = this.getInterface().getDriver(aBrowserType);
        return webDriver;
    }

    public TestStepResult execute(TestStepCommand aStep, RunTimeData aVariables, File aLogDir) throws TestSuiteException {
        ParameterArrayList parameters = aStep.getParameters();
        this.verifyParameters(parameters);
        TestStepCommandResultImpl result = new TestStepCommandResultImpl(aStep);
        SeleniumInterfaceConfiguration.SAVE_SOURCE savePageSource = this.obtainSaveSource(this.mySavePageSource, aVariables, parameters, PARSPEC_SAVE_PAGE_SOURCE);
        SeleniumInterfaceConfiguration.SAVE_SOURCE saveScreenShot = this.obtainSaveSource(this.mySaveScreenshot, aVariables, parameters, PARSPEC_SAVE_SCREEN_SHOT);
        try {
            this.doExecute(aVariables, parameters, (TestStepCommandResult)result);
            result.setResult(TestResult.VERDICT.PASSED);
        }
        catch (UnreachableBrowserException e) {
            System.out.println("Issue #19: UnreachableBrowserException caught when executing command: " + this.getCommand());
            this.getInterface().destroy();
            this.failTest(aLogDir, (TestStepResult)result, (Exception)((Object)e), savePageSource, saveScreenShot);
        }
        catch (Exception e) {
            this.failTest(aLogDir, (TestStepResult)result, e, savePageSource, saveScreenShot);
        }
        if (savePageSource.equals((Object)SeleniumInterfaceConfiguration.SAVE_SOURCE.ALWAYS)) {
            this.savePageSource(aLogDir, (TestStepResult)result);
        }
        if (saveScreenShot.equals((Object)SeleniumInterfaceConfiguration.SAVE_SOURCE.ALWAYS)) {
            this.saveScreenShot(aLogDir, (TestStepResult)result);
        }
        return result;
    }

    protected void failTest(File aLogDir, TestStepResult aResult, String aMessage, SeleniumInterfaceConfiguration.SAVE_SOURCE savePageSource, SeleniumInterfaceConfiguration.SAVE_SOURCE saveScreenShot) {
        aResult.setResult(TestResult.VERDICT.FAILED);
        if (!aMessage.isEmpty()) {
            aResult.addComment(aMessage);
        }
        if (savePageSource.equals((Object)SeleniumInterfaceConfiguration.SAVE_SOURCE.ONFAIL) || savePageSource.equals((Object)SeleniumInterfaceConfiguration.SAVE_SOURCE.ALWAYS)) {
            this.savePageSource(aLogDir, aResult);
        }
        if (saveScreenShot.equals((Object)SeleniumInterfaceConfiguration.SAVE_SOURCE.ONFAIL) || saveScreenShot.equals((Object)SeleniumInterfaceConfiguration.SAVE_SOURCE.ALWAYS)) {
            this.saveScreenShot(aLogDir, aResult);
        }
    }

    protected void failTest(File aLogDir, TestStepResult aResult, Exception e, SeleniumInterfaceConfiguration.SAVE_SOURCE savePageSource, SeleniumInterfaceConfiguration.SAVE_SOURCE saveScreenShot) {
        this.failTest(aLogDir, aResult, e.getClass().toString() + ": " + e.getMessage(), savePageSource, saveScreenShot);
    }

    @Deprecated
    protected void failTest(File aLogDir, TestStepResult aResult, String aMessage) {
        this.failTest(aLogDir, aResult, aMessage, this.mySavePageSource, this.mySaveScreenshot);
    }

    @Deprecated
    protected void failTest(File aLogDir, TestStepResult aResult, Exception e) {
        this.failTest(aLogDir, aResult, e, this.mySavePageSource, this.mySaveScreenshot);
    }

    public boolean savePageSource(File aLogDir, TestStepResult aResult) {
        try {
            WebDriver driver = this.getDriver();
            if (driver instanceof RemoteWebDriver) {
                RemoteWebDriver remDriver = (RemoteWebDriver)driver;
                String pageSource = remDriver.getPageSource();
                int i = 0;
                String sourceLogKey = "source";
                File sourceLog = new File(aLogDir, this.fileNameBase() + sourceLogKey + ".html");
                while (sourceLog.exists() && ++i < 1000) {
                    sourceLog = new File(aLogDir, this.fileNameBase() + sourceLogKey + "_" + i + ".html");
                }
                FileOutputStream sourceLogOS = new FileOutputStream(sourceLog.getAbsolutePath());
                PrintWriter pw = new PrintWriter(sourceLogOS);
                pw.println(pageSource);
                pw.flush();
                aResult.addTestLog(sourceLogKey, sourceLog.getPath());
            }
        }
        catch (Throwable t) {
            aResult.addComment("Source file could not be saved: " + t.getMessage());
            Trace.print((Trace.LEVEL)Trace.SUITE, (Throwable)t);
            return false;
        }
        return true;
    }

    public void saveScreenShot(File aLogDir, TestStepResult aResult) {
        try {
            WebDriver driver = this.getDriver();
            if (driver != null && driver.getClass().equals(RemoteWebDriver.class)) {
                driver = new Augmenter().augment(driver);
            }
            if (driver instanceof RemoteWebDriver) {
                TakesScreenshot screenShotDriver = (TakesScreenshot)driver;
                File tmpScreenFile = (File)screenShotDriver.getScreenshotAs(OutputType.FILE);
                int i = 0;
                String screenFileKey = "screen";
                File screenFile = new File(aLogDir, this.fileNameBase() + screenFileKey + ".png");
                while (screenFile.exists() && ++i < 1000) {
                    screenFile = new File(aLogDir, this.fileNameBase() + screenFileKey + "_" + i + ".png");
                }
                FileUtils.moveFile((File)tmpScreenFile, (File)screenFile);
                aResult.addTestLog(screenFileKey, screenFile.getPath());
            }
        }
        catch (Throwable t) {
            aResult.addComment("Screen file could not be saved: " + t.getMessage());
            Trace.print((Trace.LEVEL)Trace.SUITE, (Throwable)t);
        }
    }

    public void setSavePageSource(SeleniumInterfaceConfiguration.SAVE_SOURCE savePageSource) {
        this.mySavePageSource = savePageSource;
    }

    public void setSaveScreenshot(SeleniumInterfaceConfiguration.SAVE_SOURCE saveScreenshot) {
        this.mySaveScreenshot = saveScreenshot;
    }

    private String fileNameBase() {
        return this.getCommand() + "_";
    }

    public boolean verifyParameters(ParameterArrayList aParameters) throws TestSuiteException {
        Iterator paramSpecItr = this.getParametersIterator();
        while (paramSpecItr.hasNext()) {
            SpecifiedParameter paramSpec = (SpecifiedParameter)paramSpecItr.next();
            Parameter par = aParameters.get(paramSpec.getName());
            if (!this.verifyParameterExists(par, paramSpec)) continue;
            if (paramSpec.getType().equals(By.class)) {
                this.verifyBy(par, paramSpec);
                continue;
            }
            this.verifyValueOrVariable(par, paramSpec);
        }
        return true;
    }

    protected void verifyBy(Parameter par, SpecifiedParameter paramSpec) throws TestSuiteException {
        ParameterImpl valuePar;
        if (par instanceof ParameterImpl && !By.class.isAssignableFrom((valuePar = (ParameterImpl)par).getValueType())) {
            throw new TestSuiteException("Parameter " + paramSpec.getName() + " must be of type 'id', 'name'," + " 'linkText', 'partialLinkText', 'tagName', 'xPath'," + " 'className', or 'cssSelector'", this.toString());
        }
    }

    protected WebElement obtainElement(RunTimeData aVariables, ParameterArrayList parameters, SpecifiedParameter paramSpec) throws Exception {
        WebElement element = (WebElement)super.obtainValue(aVariables, parameters, paramSpec);
        if (element == null) {
            if (paramSpec.isOptional()) {
                return null;
            }
            throw new Exception("Mandatory element was not found or was not a WebElement: " + paramSpec.getName());
        }
        return element;
    }

    private SeleniumInterfaceConfiguration.SAVE_SOURCE obtainSaveSource(SeleniumInterfaceConfiguration.SAVE_SOURCE origSource, RunTimeData aVariables, ParameterArrayList parameters, SpecifiedParameter parSpec) {
        SeleniumInterfaceConfiguration.SAVE_SOURCE saveSource = origSource;
        try {
            String savePageSourceString = (String)this.obtainOptionalValue(aVariables, parameters, parSpec);
            if (!savePageSourceString.isEmpty()) {
                saveSource = SeleniumInterfaceConfiguration.SAVE_SOURCE.enumOf(savePageSourceString);
            }
        }
        catch (Exception e1) {
            // empty catch block
        }
        return saveSource;
    }
}

